/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.opplugin.checkingbilladd;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CheckingBillAddPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashSet<String> numberSet = new HashSet<String>(8);
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject dynamicObject = entity.getDataEntity();
                    numberSet.add(dynamicObject.getDynamicObject("checkingbill").getString("number"));
                }
                DynamicObjectCollection checkingBillDys = QueryServiceHelper.query((String)"fcm_checkingbill", (String)"billnumber", (QFilter[])new QFilter[]{new QFilter("billnumber", "in", numberSet)});
                HashSet<String> existNumSet = new HashSet<String>(8);
                for (DynamicObject checkingBillDyn : checkingBillDys) {
                    existNumSet.add(checkingBillDyn.getString("billnumber"));
                }
                for (ExtendedDataEntity entity : this.dataEntities) {
                    DynamicObject dynamicObject = entity.getDataEntity();
                    if (!existNumSet.contains(dynamicObject.getDynamicObject("checkingbill").getString("number"))) continue;
                    this.addMessage(entity, ResManager.loadKDString((String)"\u6240\u9009\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u6709\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CheckingBillAddPlugin_1", (String)"fi-fcm-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        ArrayList<DynamicObject> successObjs = new ArrayList<DynamicObject>();
        for (DynamicObject obj : e.getDataEntities()) {
            try {
                obj.set("billnumber", (Object)obj.getDynamicObject("checkingbill").getString("number"));
                obj.set("billname", (Object)obj.getDynamicObject("checkingbill").getString("name"));
                obj.set("lastupdatetime", (Object)new Date());
                obj.set("createtime", (Object)new Date());
                successObjs.add(obj);
            }
            catch (KDBizException exp) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u51fa\u9519\uff01", (String)"CheckingBillAddPlugin_0", (String)"fi-fcm-opplugin", (Object[])new Object[0]));
            }
        }
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }
}

