/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.opplugin.checkitem;

import java.util.Objects;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.fcm.ICheckItemStatusService;
import kd.fi.fcm.common.contexts.FcmPageContext;
import kd.fi.fcm.common.enums.FcmSystemType;
import kd.fi.fcm.validator.CheckItemEffectValidator;

public class CheckItemDisableOp
extends AbstractOperationServicePlugIn {
    private ServiceRefer<ICheckItemStatusService> checkItemStatusService = ServiceRefer.of(ICheckItemStatusService.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("enablechange");
        e.getFieldKeys().add("issyspresetbtn");
        e.getFieldKeys().add("createorg.id");
        e.getFieldKeys().add("bizappid.number");
        e.getFieldKeys().add("subbizappid");
    }

    protected Long getCurrentOperatorOrgId() {
        Optional orgFilter = FcmPageContext.getFilterValue((String)"useorg.id");
        return orgFilter.isPresent() ? Long.parseLong((String)orgFilter.get()) : RequestContext.getOrCreate().getOrgId();
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CheckItemEffectValidator(this.getCurrentOperatorOrgId(), false, this.getSubBizAppId()));
        super.onAddValidators(e);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs beforeOperationArgs) {
        DynamicObject[] dataEntities = beforeOperationArgs.getDataEntities();
        if (Objects.isNull(dataEntities) || 0 == dataEntities.length) {
            beforeOperationArgs.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u68c0\u67e5\u9879\u3002", (String)"CheckItemDisableOp_0", (String)FcmSystemType.BUSINESS.getName(), (Object[])new Object[0]));
            beforeOperationArgs.cancel = true;
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs beforeOperationArgs) {
        Long curOperateOrgId = this.getCurrentOperatorOrgId();
        for (DynamicObject checkItemDO : beforeOperationArgs.getDataEntities()) {
            ((ICheckItemStatusService)this.checkItemStatusService.get()).updateStatusByItemIdAndOrg(Long.valueOf(checkItemDO.getLong("id")), curOperateOrgId, Boolean.FALSE, this.getSubBizAppId());
        }
    }

    private String getSubBizAppId() {
        Optional subBizAppFilter = FcmPageContext.getFilterValue((String)"subbizappid");
        return subBizAppFilter.isPresent() ? (String)subBizAppFilter.get() : "";
    }
}

