/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.opplugin.schedule;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.JSONUtils;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.fcm.ICheckLogService;

public class ExecutionLogClearTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(ExecutionLogClearTask.class);
    private ServiceRefer<ICheckLogService> checkLogServiceService = ServiceRefer.of(ICheckLogService.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (Objects.isNull(map)) {
            map = Collections.EMPTY_MAP;
        }
        try {
            LOG.info("start task for clearing execution log on param: " + JSONUtils.toString((Object)map));
        }
        catch (IOException e) {
            LOG.error("failed to serialize task parameter");
        }
        Integer outMonths = Integer.parseInt(map.getOrDefault("outMonths", "3").toString());
        try {
            int delSize = ((ICheckLogService)this.checkLogServiceService.get()).clearOutDateLogs(outMonths.intValue());
            LOG.info("execute clearing check item log successfully, total delete rows: " + delSize);
        }
        catch (Exception e) {
            LOG.error("Failed to execute clearing check item log on: " + e.getMessage(), (Throwable)e);
        }
    }

    public MessageHandler getMessageHandle() {
        return null;
    }
}

