/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fcm.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fcm.business.service.ServiceRefer;
import kd.fi.fcm.business.service.fcm.IClosePeriodCheckItemService;
import kd.fi.fcm.common.domain.fcm.CheckItemDO;
import kd.fi.fcm.common.enums.FcmSystemType;

public class CheckItemEffectValidator
extends AbstractValidator {
    private ServiceRefer<IClosePeriodCheckItemService> checkItemService = ServiceRefer.of(IClosePeriodCheckItemService.class);
    private static final String[] IGNORE_CHECKITEM = new String[]{"gl_VoucherConsistent"};
    private Long operatorOrgId;
    private boolean setEffective;
    private String subBizAppId;

    public CheckItemEffectValidator(Long operatorOrgId, boolean setEffective, String subBizAppId) {
        Objects.requireNonNull(operatorOrgId);
        this.operatorOrgId = operatorOrgId;
        this.setEffective = setEffective;
        this.subBizAppId = subBizAppId;
    }

    public void validate() {
        this.setAddBillNoForContent(false);
        for (ExtendedDataEntity entity : this.dataEntities) {
            boolean superiorStatusIsEnable;
            List allSuperiorOrgs;
            DynamicObject dynamicObject = entity.getDataEntity();
            CheckItemDO checkItem = new CheckItemDO(dynamicObject);
            String namePrefix = checkItem.getName().getLocaleValue() + "\uff1a";
            boolean curIsEffective = ((IClosePeriodCheckItemService)this.checkItemService.get()).queryIsEffectiveOnOrg(Long.valueOf(dynamicObject.getLong("id")), this.operatorOrgId, this.subBizAppId);
            if (curIsEffective == this.setEffective) {
                this.addMessage(entity, namePrefix + String.format(ResManager.loadKDString((String)"\u5f53\u524d\u68c0\u67e5\u9879\u5df2\u662f%s\u72b6\u6001\u3002", (String)"CheckItemEffectValidator_0", (String)"fi-fcm-opplugin", (Object[])new Object[0]), curIsEffective ? ResManager.loadKDString((String)"\u751f\u6548", (String)"CheckItemEffectValidator_1", (String)"fi-fcm-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5931\u6548", (String)"CheckItemEffectValidator_2", (String)"fi-fcm-opplugin", (Object[])new Object[0])), ErrorLevel.Error);
                continue;
            }
            Set ignoreCheckItem = Arrays.stream(IGNORE_CHECKITEM).collect(Collectors.toSet());
            if (!checkItem.getEnableChange().booleanValue() && !ignoreCheckItem.contains(dynamicObject.getString("bizappid.number") + "_" + checkItem.getNumber())) {
                this.addMessage(entity, String.format("%1$s%2$s", namePrefix, ResManager.loadKDString((String)"\u4e3a\u7cfb\u7edf\u5185\u7f6e\u5f3a\u5236\u68c0\u67e5\u9879\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\u3002", (String)"CheckItemEffectValidator_3", (String)FcmSystemType.OPPPLUGIN.getName(), (Object[])new Object[0])), ErrorLevel.Error);
                continue;
            }
            if (this.operatorOrgId.equals(checkItem.getCreateOrgId()) || (allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"16", (long)this.operatorOrgId)).isEmpty() || !(superiorStatusIsEnable = ((IClosePeriodCheckItemService)this.checkItemService.get()).queryIsEffectiveOnOrg(checkItem.getId(), (Long)allSuperiorOrgs.get(allSuperiorOrgs.size() - 1), this.subBizAppId))) continue;
            this.addMessage(entity, String.format("%1$s%2$s", namePrefix, ResManager.loadKDString((String)"\u4e0a\u7ea7\u7ec4\u7ec7\u5df2\u751f\u6548\uff0c\u4e0b\u7ea7\u7ec4\u7ec7\u5fc5\u987b\u751f\u6548\u3002", (String)"CheckItemEffectValidator_4", (String)FcmSystemType.OPPPLUGIN.getName(), (Object[])new Object[0])), ErrorLevel.Error);
        }
    }
}

