/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export;

import com.alibaba.fastjson.JSONObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.getFilterHandle.IGetFilterHandle;
import kd.fi.fea.opservice.export.factory.FilterHandleFactory;

public class ExportPlanFilterAdapt {
    private static Log logger = LogFactory.getLog(ExportPlanFilterAdapt.class);
    private FileSingleExportContext singleExportContext;
    private String commonfilter;

    public ExportPlanFilterAdapt(FileSingleExportContext singleExportContext, String commonfilter) {
        this.commonfilter = commonfilter;
        this.singleExportContext = singleExportContext;
    }

    private List<IGetFilterHandle> addFilterHandleList(String entity) {
        List<IGetFilterHandle> handles = FilterHandleFactory.getCommonFilterHandle(entity, this.commonfilter, this.singleExportContext);
        return handles;
    }

    public Set<QFilter> adaptFilterProperty(String entity) {
        String otherFilter;
        HashSet<QFilter> qFilters = new HashSet<QFilter>(4);
        List<IGetFilterHandle> handles = this.addFilterHandleList(entity);
        for (IGetFilterHandle handle : handles) {
            List<Object> qFilterList = handle.compile().getFilters();
            if (null == qFilterList || qFilterList.size() <= 0) continue;
            qFilterList = qFilterList.stream().filter(Objects::nonNull).collect(Collectors.toList());
            qFilters.addAll(qFilterList);
        }
        JSONObject valueMap = JSONObject.parseObject((String)this.commonfilter);
        if (valueMap != null && valueMap.containsKey("otherfilter") && StringUtils.isNotEmpty((String)(otherFilter = (String)valueMap.get("otherfilter")))) {
            try {
                QFilter filter = QFilter.of((String)otherFilter, (Object[])new Object[0]);
                qFilters.add(filter);
            }
            catch (Exception e) {
                logger.error("\u901a\u7528\u8fc7\u6ee4\u8868\u8fbe\u5f0f({})\u89e3\u6790\u5931\u8d25", (Object)otherFilter, (Object)e);
            }
        }
        return qFilters;
    }
}

