/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.Collection;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DSField;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.opservice.export.builder.ext.AccountAssQueryUtils;

public class AccountAssExportExtHandle
extends AbstractExportExtHandle {
    private static final String STRUCT_0203 = "0203";
    private static final String ELEMENT_020303 = "020303";

    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        ExprotPlanInfo exprotPlanInfo = context.getExprotPlanInfo();
        if (this.isAccountAss(context)) {
            entryQFilters.add(new QFilter("isassist", "=", (Object)Boolean.TRUE));
        }
        AccountBookInfo accountBook = context.getSingleExportContext().getAcctBookInfo();
        entryQFilters.add(new QFilter("accounttable", "=", (Object)accountBook.getAccountTableId()));
        Long endPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getEndperiodId();
        Set<QFilter> accountAssVersionFilter = AccountAssQueryUtils.getAccountAssVersionFilter(endPeriodId);
        entryQFilters.addAll(accountAssVersionFilter);
        return entryQFilters;
    }

    @Override
    public String getSelectPropertis(StructureSingleExportContext context, String selectPropertis) {
        if (this.isAccountAss(context)) {
            return super.getSelectPropertis(context, selectPropertis) + ",checkitementry.asstactitem.valuesource.number baseEntityNumber";
        }
        return super.getSelectPropertis(context, selectPropertis);
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        DataSet originDataSet = super.getDataSource(context, dataSet, originFilters);
        AccountBookInfo accountBook = context.getSingleExportContext().getAcctBookInfo();
        DSField comAssist = accountBook.getComAssist();
        if (comAssist == null || CollectionUtils.isEmpty((Collection)context.getExprotPlanInfo().getComAssistFilter())) {
            return originDataSet;
        }
        if (!this.isAccountAss(context)) {
            return originDataSet;
        }
        originDataSet = originDataSet.updateField("checkitementry.seq", "checkitementry.seq + 1");
        DataSet acctDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)context.getEntityName(), (String)"id,number, 1 checkitementry.seq", (QFilter[])originFilters.toArray(new QFilter[0]), (String)"");
        acctDataSet = acctDataSet.addField("'" + comAssist.getFieldName().getLocaleValue() + "'", "checkitementry.asstactitem.name");
        acctDataSet = acctDataSet.addField("'" + comAssist.getDataType() + "'", "checkitementry.asstactitem.valuetype");
        acctDataSet = acctDataSet.addField("'" + comAssist.getFieldValue().toString() + "'", "checkitementry.asstactitem.valuesource.name");
        acctDataSet = acctDataSet.addField("'" + comAssist.getFieldValue().toString() + "'", "checkitementry.asstactitem.assistanttype.name");
        acctDataSet = acctDataSet.addField("'" + comAssist.getEntityId() + "'", "baseEntityNumber");
        String[] selectFields = originDataSet.getRowMeta().getFieldNames();
        acctDataSet = acctDataSet.select(selectFields);
        originDataSet = originDataSet.union(acctDataSet);
        originDataSet = originDataSet.orderBy(new String[]{"number", "checkitementry.seq"});
        return originDataSet;
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        if (this.isAccountAss(context)) {
            String valueDesc = structureEntry.getValuedesc();
            String valueNumber = structureEntry.getStructName();
            if (ELEMENT_020303.equals(valueNumber)) {
                String baseEntityNumber = row.getString("baseEntityNumber");
                if ("bd_supplier".equals(baseEntityNumber)) {
                    return ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"AccountAssExportExtHandle_2", (String)"fi-fea-business", (Object[])new Object[0]);
                }
                if ("bd_customer".equals(baseEntityNumber)) {
                    return ResManager.loadKDString((String)"\u5ba2\u6237", (String)"AccountAssExportExtHandle_3", (String)"fi-fea-business", (Object[])new Object[0]);
                }
                if ("bos_adminorg".equals(baseEntityNumber)) {
                    return ResManager.loadKDString((String)"\u90e8\u95e8", (String)"AccountAssExportExtHandle_4", (String)"fi-fea-business", (Object[])new Object[0]);
                }
                if ("bos_user".equals(baseEntityNumber)) {
                    return ResManager.loadKDString((String)"\u5458\u5de5", (String)"AccountAssExportExtHandle_5", (String)"fi-fea-business", (Object[])new Object[0]);
                }
            }
        }
        return super.parseExpression(context, row, structureEntry, nodeInfo, elementValue);
    }

    private boolean isAccountAss(StructureSingleExportContext context) {
        String elementNumber = context.getStructure().getNumber();
        return STRUCT_0203.equals(elementNumber);
    }
}

