/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;

public class AccountAssQueryUtils {
    private static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");

    public static Set<QFilter> getAccountAssVersionFilter(Long endPeriodId) {
        Date endDate = null;
        try {
            DynamicObject curPeriodDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (QFilter[])new QFilter("id", "=", (Object)endPeriodId).toArray());
            Date date = curPeriodDyn.getDate("enddate");
            String dateStr = simpleDateFormat.format(date);
            endDate = simpleDateFormat.parse(dateStr);
        }
        catch (ParseException curPeriodDyn) {
            // empty catch block
        }
        HashSet<QFilter> filters = new HashSet<QFilter>(2);
        QFilter startFilter = new QFilter("startdate", "<=", endDate);
        QFilter endFilter = new QFilter("enddate", ">", endDate);
        filters.add(startFilter);
        filters.add(endFilter);
        return filters;
    }

    public static List<QFilter> getAccountQueryFilter(StructureSingleExportContext context) {
        ArrayList<QFilter> entryQFilters = new ArrayList<QFilter>(3);
        ExprotPlanInfo exprotPlanInfo = context.getExprotPlanInfo();
        Long beginPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getBeginperiodId();
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)context.getOrgId(), (long)exprotPlanInfo.getBookTypeId(), (long)beginPeriodId);
        if (accountBook == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7:%1$s\uff0c\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AccountAssQueryUtils_2", (String)"fi-fea-business", (Object[])new Object[0]), context.getOrgName(), exprotPlanInfo.getBookTypeName()));
        }
        entryQFilters.add(new QFilter("accounttable", "=", (Object)accountBook.getAccountTableId()));
        Long endPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getEndperiodId();
        Set<QFilter> accountAssVersionFilter = AccountAssQueryUtils.getAccountAssVersionFilter(endPeriodId);
        entryQFilters.addAll(accountAssVersionFilter);
        return entryQFilters;
    }
}

