/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DSField;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.VoucherExportExtHandle;
import kd.fi.fea.util.FeaUtil;

public class BalanceExportExtHandle
extends VoucherExportExtHandle {
    private static final int INIT_CAPACITY = 1024;
    private static final String LOCAL = "local";
    private static final String FOR = "for";
    private static final String QTY = "qty";
    private static final String ENDDC = "enddc";
    private static final String BEGINDC = "begindc";
    private static final String PERIODYEAR = "periodyear";
    private static final String PERIODNUMBER = "periodnumber";
    private List<String> amountTypes;
    private StructureSingleExportContext context;
    private static final String[] STARTWITHS = new String[]{"begin", "debit", "credit", "yeardebit", "yearcredit", "end"};

    @Override
    protected String getComAssistFieldPrefix() {
        return "";
    }

    @Override
    protected void compiler(StructureSingleExportContext context) {
        super.compiler(context);
        Map<String, String> map = context.getExpPropNameMap();
        map.put("period.periodyear", PERIODYEAR);
        map.put("period.periodnumber", PERIODNUMBER);
        map.put(BEGINDC, BEGINDC);
        map.put(ENDDC, ENDDC);
        this.amountTypes = new ArrayList<String>();
        this.amountTypes.add(LOCAL);
        this.amountTypes.add(FOR);
        this.amountTypes.add(QTY);
    }

    @Override
    protected void initExtraPropAndFieldMap(Map<String, String> map) {
        map.put("account.number", "account.number");
        map.put("assgrp.id", "assgrp");
    }

    @Override
    protected void initExtraPropAndAliasMap(Map<String, String> map) {
        map.put("account.number", "number");
    }

    @Override
    protected void addRemoveFields(Set<String> removeFields) {
        removeFields.add("period.periodyear");
        removeFields.add("period.periodnumber");
    }

    @Override
    protected void addBillSpecialField(Set<String> sp) {
        sp.add("account");
        sp.add("account.dc dc");
        sp.add("account.isleaf isleaf");
        sp.add("account.isassist isassist");
        sp.add("account.parent parentact");
        sp.add("account.level actlevel");
    }

    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        return entryQFilters;
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext singleExportContext, DataSet dataSet, Set<QFilter> originFilters) {
        this.context = singleExportContext;
        ExprotPlanInfo exportPlanInfo = this.context.getExprotPlanInfo();
        AccountBookInfo accountBook = this.context.getSingleExportContext().getAcctBookInfo();
        List periodIds = AccSysUtil.getPeriodIds((Long)exportPlanInfo.getBeginperiodId(), (Long)exportPlanInfo.getEndperiodId(), (boolean)true);
        DynamicObjectCollection periodInfos = QueryServiceHelper.query((String)"bd_period", (String)"id, periodyear, periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)periodIds)});
        BalanceQueryExecutor balanceQueryService = BalanceQueryExecutor.getInstance();
        QueryParam balanceQueryParam = new QueryParam();
        balanceQueryParam.setSpecialAccount(false);
        if (this.comAssistField != null && CollectionUtils.isNotEmpty((Collection)exportPlanInfo.getComAssistFilter())) {
            DSField comAssist = accountBook.getComAssist();
            if ("1".equals(comAssist.getDataType())) {
                DynamicObject[] masterIdDyns = BusinessDataServiceHelper.load((String)comAssist.getEntityId(), (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)exportPlanInfo.getComAssistFilter())});
                Set masterIdSet = Arrays.stream(masterIdDyns).map(obj -> obj.getLong("masterid")).collect(Collectors.toSet());
                balanceQueryParam.getCustomFilter().add(new QFilter(this.comAssistField, "in", (Object)masterIdSet));
            } else {
                balanceQueryParam.getCustomFilter().add(new QFilter(this.comAssistField, "in", (Object)exportPlanInfo.getComAssistFilter()));
            }
        }
        Long periodId = null;
        DataSet resDataSet = null;
        for (DynamicObject period : periodInfos) {
            periodId = period.getLong("id");
            DataSet balanceDataSet = balanceQueryService.getBalance(this.context.getSelectPropertis(), new Long[]{this.context.getOrgId()}, exportPlanInfo.getBookTypeId().longValue(), accountBook.getAccountTableId(), periodId.longValue(), periodId.longValue(), balanceQueryParam);
            List selectFields = FeaUtil.getDataSetCols((DataSet)balanceDataSet);
            selectFields.remove("assgrp");
            selectFields.add("number account.number");
            selectFields.add("'" + period.get(PERIODYEAR) + "' periodyear");
            selectFields.add("'" + period.get(PERIODNUMBER) + "' periodnumber");
            selectFields.add("case when isleaf or isassist then assgrp else 0 end assgrp");
            balanceDataSet = balanceDataSet.select(selectFields.toArray(new String[0]));
            if (resDataSet == null) {
                resDataSet = balanceDataSet;
                continue;
            }
            resDataSet = resDataSet.union(balanceDataSet);
        }
        if (resDataSet == null) {
            return null;
        }
        List fields = FeaUtil.getDataSetCols(resDataSet);
        ArrayList<String> sumBy = new ArrayList<String>(12);
        for (String startWith : STARTWITHS) {
            for (String amountType : this.amountTypes) {
                String field = startWith + amountType;
                if (!fields.contains(field)) continue;
                sumBy.add(field);
            }
        }
        fields.removeAll(sumBy);
        resDataSet = FeaUtil.gainSumSet(resDataSet, (String[])fields.toArray(new String[0]), (String[])sumBy.toArray(new String[0]));
        List selectFields = FeaUtil.getDataSetCols((DataSet)resDataSet);
        this.addAmountBalFields("begin", selectFields);
        this.addAmountBalFields("end", selectFields);
        resDataSet = resDataSet.select(selectFields.toArray(new String[0])).orderBy(new String[]{PERIODYEAR, PERIODNUMBER, "number"});
        return resDataSet;
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        if (null == structureEntry.getValueMap()) {
            return elementValue;
        }
        if (structureEntry.getElement().isAssistItem()) {
            Long assgrpId = Long.valueOf(elementValue.toString());
            nodeInfo.setAssgrpId(assgrpId);
            nodeInfo.setAssgrpIndex(structureEntry.getSeq());
            this.addCurAssgrpId(assgrpId);
            if (this.comAssistField != null && CollectionUtils.isNotEmpty((Collection)context.getExprotPlanInfo().getComAssistFilter())) {
                Long comAssistVal = row.getLong(this.comAssistField);
                this.comAssistValSet.add(comAssistVal);
                nodeInfo.setComAssistVal(comAssistVal);
            }
        } else {
            String propName;
            Map valueMap = structureEntry.getValueMap();
            switch (propName = (String)valueMap.get("value")) {
                case "account.number": {
                    Long masterId = row.getLong("account");
                    nodeInfo.setAccountId(masterId);
                    break;
                }
            }
        }
        return elementValue;
    }

    private void addAmountBalFields(String amountFieldName, List<String> selectFields) {
        selectFields.add(String.format("case when %slocal = 0 then '0' else dc end %sdc", amountFieldName, amountFieldName));
        for (String amountType : this.amountTypes) {
            String field = amountFieldName + amountType;
            selectFields.add(String.format("%s * (case dc when '1' then 1 else -1 end) %s", field, field));
            selectFields.remove(field);
        }
    }
}

