/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.opservice.export.builder.ext.AccountAssQueryUtils;

public class CSVAccountExportExtHandle
extends AbstractExportExtHandle {
    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        ExprotPlanInfo exprotPlanInfo = context.getExprotPlanInfo();
        Long beginPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getBeginperiodId();
        AccountBookInfo accountBook = AccSysUtil.getBookFromAccSys((long)context.getOrgId(), (long)exprotPlanInfo.getBookTypeId(), (long)beginPeriodId);
        if (accountBook == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7:%1$s\uff0c\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AccountTableExportExtHandle_2", (String)"fi-fea-business", (Object[])new Object[0]), context.getOrgName(), exprotPlanInfo.getBookTypeName()));
        }
        entryQFilters.add(new QFilter("accounttable", "=", (Object)accountBook.getAccountTableId()));
        Long endPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getEndperiodId();
        Set<QFilter> accountAssVersionFilter = AccountAssQueryUtils.getAccountAssVersionFilter(endPeriodId);
        entryQFilters.addAll(accountAssVersionFilter);
        return entryQFilters;
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        ExprotPlanInfo exprotPlanInfo = context.getSingleExportContext().getExportContext().getExprotPlanInfo();
        Long beginPeriodId = exprotPlanInfo.getBeginperiodId();
        Long endPeriodId = exprotPlanInfo.getEndperiodId();
        HashSet<String> years = new HashSet<String>();
        DataSet ds = QueryServiceHelper.queryDataSet((String)"GLAccountBookExportExtHandle", (String)"bd_period", (String)"periodyear", (QFilter[])new QFilter[]{new QFilter("id", ">=", (Object)beginPeriodId), new QFilter("id", "<=", (Object)endPeriodId)}, null);
        Object object = null;
        try {
            while (ds.hasNext()) {
                years.add(ds.next().getString("periodyear"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        DataSet newDs = null;
        for (String year : years) {
            if (newDs == null) {
                newDs = dataSet.copy().addField(year + "", "exportyear");
                continue;
            }
            newDs = newDs.union(dataSet.copy().addField(year, "exportyear"));
        }
        return newDs;
    }
}

