/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.opservice.export.builder.ext.AccountAssQueryUtils;

public class CSVBalanceExportExtHandle
extends AbstractExportExtHandle {
    private static final int INIT_CAPACITY = 1024;
    private StructureSingleExportContext context;
    protected static final String BALANCESELECTOR = "account.dc account.dc, account.id, beginlocal";
    protected static final String BALANCEENDSELECTOR = "account.dc account.dc, account.id, endlocal beginlocal";
    private static final Log log = LogFactory.getLog(CSVBalanceExportExtHandle.class);
    private Set<Long> leafAccts;

    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        return entryQFilters;
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        this.context = context;
        long orgId = context.getSingleExportContext().getOrgId();
        long bookTypeId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getBookTypeId();
        this.leafAccts = new HashSet<Long>(1024);
        AccountBookInfo bookInfo = context.getSingleExportContext().getAcctBookInfo();
        ArrayList<QFilter> acctFilter = new ArrayList<QFilter>(5);
        QFilter atF = new QFilter("accounttable", "=", (Object)bookInfo.getAccountTableId());
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        acctFilter.add(atF);
        acctFilter.add(baseDataFilter);
        acctFilter.add(leafFilter);
        Long endPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getEndperiodId();
        Set<QFilter> accountAssVersionFilter = AccountAssQueryUtils.getAccountAssVersionFilter(endPeriodId);
        acctFilter.addAll(accountAssVersionFilter);
        DataSet accountDS = QueryServiceHelper.queryDataSet((String)"BalanceExportPlanSingleWrite.getAccountInfos", (String)"bd_accountview", (String)"id, masterid, number, dc", (QFilter[])acctFilter.toArray(new QFilter[0]), null);
        GroupbyDataSet accountGroup = accountDS.copy().groupBy(new String[]{"masterid"}).maxP("id", "id");
        DataSet acctMidSet = accountGroup.finish();
        accountDS = accountDS.join(acctMidSet).on("id", "id").select(new String[]{"masterid", "number", "dc"}, new String[0]).finish();
        for (Row row : accountDS.copy()) {
            Long masterId = row.getLong("masterid");
            this.leafAccts.add(masterId);
        }
        long acctTableId = bookInfo.getAccountTableId();
        long bookStartPeriod = bookInfo.getStartPeriodId();
        long beginExpPeriodId = context.getSingleExportContext().getExportContext().getExprotPlanInfo().getBeginperiodId();
        long periodId = this.getPeriodId(bookStartPeriod, beginExpPeriodId);
        String periodNumber = this.getPeriodNumber(periodId, beginExpPeriodId);
        long currencyId = bookInfo.getBaseCurrencyId();
        QFilter accountFilter = new QFilter("account", "in", this.leafAccts);
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookTypeId);
        QFilter accountTableFilter = new QFilter("accounttable", "=", (Object)acctTableId);
        QFilter periodFilter = new QFilter("period", "<=", (Object)periodId);
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodyear", (QFilter[])new QFilter[]{new QFilter("id", "in", Arrays.asList(beginExpPeriodId, bookStartPeriod, periodId))});
        Map<Long, Integer> periodYearMap = periods.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getInt("periodyear")));
        Integer exportBeginYear = periodYearMap.get(beginExpPeriodId);
        Integer queryPeriodYear = periodYearMap.get(periodId);
        Integer bookStartPeriodYear = periodYearMap.get(bookStartPeriod);
        String year = String.valueOf(Math.max(exportBeginYear, bookStartPeriodYear));
        DataSet newDs = null;
        QFilter localAmountFilter = null;
        String selecters = BALANCESELECTOR;
        if (periodId == bookInfo.getStartPeriodId()) {
            if (exportBeginYear.compareTo(queryPeriodYear) == 0) {
                localAmountFilter = new QFilter("beginlocal", "!=", (Object)0);
            } else {
                selecters = BALANCEENDSELECTOR;
                localAmountFilter = new QFilter("endlocal", "!=", (Object)0);
            }
        } else {
            selecters = BALANCEENDSELECTOR;
            localAmountFilter = new QFilter("endlocal", "!=", (Object)0);
        }
        QFilter endPeriodFilter = new QFilter("endperiod", ">", (Object)periodId);
        QFilter[] filters = new QFilter[]{accountFilter, orgFilter, bookTypeFilter, accountTableFilter, periodFilter, endPeriodFilter, localAmountFilter};
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"gl_balance", (String)selecters, (QFilter[])filters, null);
        ds = ds.leftJoin(accountDS).on("account.id", "masterid").select(new String[]{"beginlocal"}, new String[]{"dc account.dc", "number account.number"}).finish();
        DataSet sumDs = ds.groupBy(new String[]{"account.dc", "account.number"}).sum("beginlocal").finish();
        newDs = sumDs.filter("beginlocal != 0").addFields(new String[]{year, periodNumber}, new String[]{"exportyear", "firstperiod"});
        return newDs;
    }

    private Long getPeriodId(Long bookPeriod, Long exportPeriod) {
        Long periodId;
        Long l = periodId = exportPeriod - bookPeriod > 0L ? exportPeriod : bookPeriod;
        if (periodId == null) {
            periodId = 0L;
        }
        if (bookPeriod == null) {
            bookPeriod = 0L;
        }
        if (BigDecimal.valueOf(periodId).compareTo(BigDecimal.valueOf(bookPeriod)) != 0) {
            DynamicObject periodObj;
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)periodId, (String)entityName);
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", (Object)periodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
            DynamicObject dynamicObject = periodObj = coll != null && !coll.isEmpty() ? (DynamicObject)coll.get(0) : null;
            if (periodObj != null) {
                periodId = periodObj.getLong("id");
            }
        }
        return periodId;
    }

    private String getPeriodNumber(Long bookPeriod, Long exportPeriod) {
        String entityName = "bd_period";
        Long periodId = exportPeriod > bookPeriod ? exportPeriod : bookPeriod;
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject currPeriod = QueryServiceHelper.queryOne((String)entityName, (String)"periodnumber", (QFilter[])new QFilter[]{filter});
        if (currPeriod == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4f1a\u8ba1\u671f\u95f4\u6570\u636e\u4e0d\u6b63\u786e", (String)"CSVBalanceExportExtHandle_1", (String)"fi-fea-business", (Object[])new Object[0]), this.context.getOrgName()));
        }
        return currPeriod.getString("periodnumber");
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        if (null == structureEntry.getValueMap()) {
            return elementValue;
        }
        return elementValue;
    }
}

