/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.ArrayList;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.DataStructureExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.CustomFileKeyExportExtHandle;

public class CustomFileExportExtHandle
extends CustomFileKeyExportExtHandle {
    private static final Log logger = LogFactory.getLog(CustomFileExportExtHandle.class);
    private static final String ELEMENT_011101 = "011101";
    private static final String ELEMENT_011201 = "011201";
    private static final String ELEMENT_011202 = "011202";

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        DataStructureExportPlanModel structure = context.getStructure();
        String entity = structure.getEntity();
        if (!"fea_custom_value".equals(entity)) {
            return dataSet;
        }
        DynamicObjectCollection usedAsstTypes = this.queryUsedAsstTypes(context);
        DataSet resDataSet = null;
        for (DynamicObject row : usedAsstTypes) {
            String number = row.getString("number");
            String valueType = row.getString("valuetype");
            if ("1".equals(valueType)) {
                String entityName = row.getString("valuesource.number");
                if (EXCLUDE_ASS_TYPE.contains(entityName)) continue;
                BasedataEntityType dataEntityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityName);
                String tableName = dataEntityType.getAlias();
                if (StringUtils.isEmpty((CharSequence)tableName)) {
                    logger.warn("the table of entity {} is not exists !", (Object)entityName);
                    continue;
                }
                String numberProperty = dataEntityType.getNumberProperty();
                String nameProperty = dataEntityType.getNameProperty();
                if (StringUtils.isEmpty((CharSequence)numberProperty) && StringUtils.isEmpty((CharSequence)nameProperty)) {
                    logger.warn("the number and name of entity {} is null !", (Object)entityName);
                    continue;
                }
                ArrayList<QFilter> filterList = new ArrayList<QFilter>(2);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)entityName, (Long)context.getOrgId());
                filterList.add(baseDataFilter);
                DataSet baseObjectDataSet = QueryServiceHelper.queryDataSet((String)number, (String)entityName, (String)("'" + number + "' typenumber, " + numberProperty + " number," + nameProperty + " name"), (QFilter[])filterList.toArray(new QFilter[0]), (String)numberProperty);
                if (resDataSet == null) {
                    resDataSet = baseObjectDataSet;
                    continue;
                }
                resDataSet = resDataSet.union(baseObjectDataSet);
                continue;
            }
            if ("2".equals(valueType)) {
                long valueSourcePk = row.getLong("assistanttype.id");
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_assistantdata_detail", (Long)context.getOrgId());
                QFilter[] typeFilter = new QFilter[]{baseDataFilter, new QFilter("group", "=", (Object)valueSourcePk)};
                DataSet baseObjectDataSet = QueryServiceHelper.queryDataSet((String)"", (String)"bos_assistantdata_detail", (String)("'" + number + "' typenumber,number, name"), (QFilter[])typeFilter, (String)"number");
                if (resDataSet == null) {
                    resDataSet = baseObjectDataSet;
                    continue;
                }
                resDataSet = resDataSet.union(baseObjectDataSet);
                continue;
            }
            if (!"3".equals(valueType)) continue;
        }
        return resDataSet;
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        String structName = structureEntry.getStructName();
        if (ELEMENT_011101.equals(structName)) {
            return row.getString(0);
        }
        if (ELEMENT_011201.equals(structName)) {
            return row.getString(1);
        }
        if (ELEMENT_011202.equals(structName)) {
            return row.getString(2);
        }
        return super.parseExpression(context, row, structureEntry, nodeInfo, elementValue);
    }
}

