/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DSField;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.opservice.export.builder.ext.AccountAssQueryUtils;

public class CustomFileKeyExportExtHandle
extends AbstractExportExtHandle {
    private static final Log logger = LogFactory.getLog(CustomFileKeyExportExtHandle.class);
    protected static final Set<String> EXCLUDE_ASS_TYPE = new HashSet<String>(Arrays.asList("bd_customer", "bd_supplier", "bos_adminorg", "bos_user"));

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        DynamicObjectCollection usedAsstTypes = this.queryUsedAsstTypes(context);
        return this.toDataSet(usedAsstTypes);
    }

    @Override
    public String getSelectPropertis(StructureSingleExportContext context, String selectPropertis) {
        return "id";
    }

    protected DynamicObjectCollection queryUsedAsstTypes(StructureSingleExportContext context) {
        List<QFilter> accountFilter = AccountAssQueryUtils.getAccountQueryFilter(context);
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)context.getOrgId());
        accountFilter.add(qFilter);
        accountFilter.add(new QFilter("enable", "=", (Object)true));
        DynamicObjectCollection asstactTypeColl = QueryServiceHelper.query((String)"bd_accountview", (String)"checkitementry.asstactitem asstactitem", (QFilter[])accountFilter.toArray(new QFilter[0]));
        Set idSet = asstactTypeColl.stream().map(m -> m.getLong("asstactitem")).collect(Collectors.toSet());
        QFilter filter1 = new QFilter("id", "in", idSet);
        QFilter filter2 = new QFilter("valuesource.number", "not in", EXCLUDE_ASS_TYPE).and(new QFilter("valuetype", "in", Arrays.asList("1", "2")));
        DynamicObjectCollection usedAsstTypes = QueryServiceHelper.query((String)"bd_asstacttype", (String)"number, name, valuetype, valuesource.number, valuesource.name, assistanttype.id, assistanttype.name", (QFilter[])new QFilter[]{filter1, filter2});
        Set comAssistFilter = context.getExprotPlanInfo().getComAssistFilter();
        AccountBookInfo acctBookInfo = context.getSingleExportContext().getAcctBookInfo();
        DSField comAssist = acctBookInfo.getComAssist();
        if (CollectionUtils.isEmpty((Collection)comAssistFilter) || comAssist == null) {
            return usedAsstTypes;
        }
        boolean containsComAssist = false;
        for (DynamicObject usedAsstType : usedAsstTypes) {
            String valuetype = usedAsstType.getString("valuetype");
            String entityid = "";
            if ("1".equals(valuetype)) {
                entityid = usedAsstType.getString("valuesource.number");
                if (!valuetype.equals(comAssist.getDataType()) || !entityid.equals(comAssist.getEntityId())) continue;
                containsComAssist = true;
                break;
            }
            entityid = usedAsstType.getString("assistanttype.id");
            if (!valuetype.equals(comAssist.getDataType()) || !entityid.equals(comAssist.getGroupId().toString())) continue;
            containsComAssist = true;
            break;
        }
        if (containsComAssist) {
            return usedAsstTypes;
        }
        DynamicObject comAssistDyn = new DynamicObject(usedAsstTypes.getDynamicObjectType());
        comAssistDyn.set("number", (Object)comAssist.getFieldNumber());
        comAssistDyn.set("name", (Object)comAssist.getFieldName().getLocaleValue());
        comAssistDyn.set("valuetype", (Object)comAssist.getDataType());
        if ("1".equals(comAssist.getDataType())) {
            comAssistDyn.set("valuesource.number", (Object)comAssist.getEntityId());
            comAssistDyn.set("valuesource.name", (Object)comAssist.getFieldValue().toString());
        } else {
            comAssistDyn.set("assistanttype.id", (Object)comAssist.getGroupId());
            comAssistDyn.set("assistanttype.name", (Object)comAssist.getFieldValue().toString());
        }
        usedAsstTypes.add((Object)comAssistDyn);
        return usedAsstTypes;
    }

    protected DataSet toDataSet(DynamicObjectCollection usedAsstTypes) {
        DataSetBuilder builder = Algo.create((String)"fea_customfile_handle").createDataSetBuilder(new RowMeta(new String[]{"number", "name", "valuetype", "valuesource.name", "assistanttype.name"}, new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType}));
        for (DynamicObject usedAsstType : usedAsstTypes) {
            builder.append(new Object[]{usedAsstType.get("number"), usedAsstType.getString("name"), usedAsstType.getString("valuetype"), usedAsstType.getString("valuesource.name"), usedAsstType.getString("assistanttype.name")});
        }
        return builder.build();
    }
}

