/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.util.FeaUtil;

public class FaCardRealExportExtHandle
extends AbstractExportExtHandle {
    private DynamicObject reconScheme;
    private Map<String, List<String>> reconAcctsMap;
    private static final String ALLWORKMETHOD_NUM = "400";
    private static final String BIZ_PERIOD = "bizperiod";
    private static final String END_PERIOD = "endperiod";
    private static final String CLEAR_PERIOD = "clearperiod";

    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        entryQFilters.removeIf(filter -> "assetbook".equals(filter.getProperty()));
        entryQFilters.add(new QFilter(BIZ_PERIOD, "<", (Object)CLEAR_PERIOD, true).or(new QFilter(CLEAR_PERIOD, "=", (Object)0L)));
        ExprotPlanInfo exportPlanInfo = context.getExprotPlanInfo();
        entryQFilters.add(new QFilter(END_PERIOD, ">", (Object)exportPlanInfo.getEndperiodId()));
        entryQFilters.add(new QFilter(BIZ_PERIOD, "<=", (Object)exportPlanInfo.getBeginperiodId()));
        return entryQFilters;
    }

    @Override
    public String getSelectPropertis(StructureSingleExportContext context, String selectPropertis) {
        if (!selectPropertis.contains(BIZ_PERIOD)) {
            selectPropertis = selectPropertis + ",bizperiod";
        }
        if (!selectPropertis.contains(END_PERIOD)) {
            selectPropertis = selectPropertis + ",endperiod";
        }
        return selectPropertis;
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        this.reconScheme = this.getReconScheme(context.getOrgId(), context.getExprotPlanInfo().getBookTypeId());
        if (this.reconScheme != null) {
            this.reconAcctsMap = this.getReconAcctsMap(this.reconScheme);
        }
        ExprotPlanInfo exportPlanInfo = context.getExprotPlanInfo();
        Long startPeriodId = exportPlanInfo.getBeginperiodId();
        Long endPeriodId = exportPlanInfo.getEndperiodId();
        List periodIds = AccSysUtil.getPeriodIds((Long)startPeriodId, (Long)endPeriodId, (boolean)false);
        Map periodInfoMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"periodyear, periodnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)periodIds)});
        DataSet resultSet = null;
        String periodFilter = "endperiod >%s and bizperiod <= %s";
        for (Long periodId : periodIds) {
            DataSet tmpSet = dataSet.copy().filter(String.format(periodFilter, periodId, periodId));
            DynamicObject periodInfo = (DynamicObject)periodInfoMap.get(periodId);
            if (periodInfo == null) continue;
            List cols = FeaUtil.getDataSetCols((DataSet)tmpSet);
            cols.remove("period.periodnumber");
            cols.add(String.format("'%s' period.periodnumber", periodInfo.getString("periodnumber")));
            tmpSet = tmpSet.select(cols.toArray(new String[0]));
            if (resultSet == null) {
                resultSet = tmpSet;
                continue;
            }
            resultSet = resultSet.union(tmpSet);
        }
        return resultSet;
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        String valuedesc = structureEntry.getValuedesc();
        if (this.reconAcctsMap != null) {
            if (valuedesc.contains(ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7\u5bf9\u8d26\u79d1\u76ee", (String)"FaCardRealExportExtHandle_0", (String)"fi-fea-business", (Object[])new Object[0]))) {
                elementValue = this.getReconAccountNum("yz");
            } else if (valuedesc.contains(ResManager.loadKDString((String)"\u51cf\u503c\u51c6\u5907\u5bf9\u8d26\u79d1\u76ee", (String)"FaCardRealExportExtHandle_1", (String)"fi-fea-business", (Object[])new Object[0]))) {
                elementValue = this.getReconAccountNum("jz");
            } else if (valuedesc.contains(ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7\u5bf9\u8d26\u79d1\u76ee", (String)"FaCardRealExportExtHandle_2", (String)"fi-fea-business", (Object[])new Object[0]))) {
                elementValue = this.getReconAccountNum("zz");
            }
        }
        String depremethodNum = null;
        try {
            depremethodNum = row.getString("depremethod.number");
            if (depremethodNum != null && depremethodNum.equals(ALLWORKMETHOD_NUM)) {
                if (valuedesc.contains(ResManager.loadKDString((String)"\u56fa\u5b9a\u8d44\u4ea7\u5de5\u4f5c\u603b\u91cf", (String)"FaCardRealExportExtHandle_3", (String)"fi-fea-business", (Object[])new Object[0]))) {
                    elementValue = row.get("preusingamount");
                } else if (valuedesc.contains(ResManager.loadKDString((String)"\u7d2f\u8ba1\u5de5\u4f5c\u603b\u91cf", (String)"FaCardRealExportExtHandle_4", (String)"fi-fea-business", (Object[])new Object[0]))) {
                    elementValue = row.get("depredamount");
                } else if (valuedesc.contains(ResManager.loadKDString((String)"\u9884\u8ba1\u4f7f\u7528\u6708\u4efd", (String)"FaCardRealExportExtHandle_5", (String)"fi-fea-business", (Object[])new Object[0]))) {
                    elementValue = null;
                } else if (valuedesc.contains(ResManager.loadKDString((String)"\u5df2\u8ba1\u63d0\u6708\u4efd", (String)"FaCardRealExportExtHandle_6", (String)"fi-fea-business", (Object[])new Object[0]))) {
                    elementValue = null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return elementValue;
    }

    private String getReconAccountNum(String key) {
        StringBuilder sb = new StringBuilder();
        List<String> list = this.reconAcctsMap.get(key);
        for (String acct : list) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(acct);
        }
        return sb.toString();
    }

    private Map<String, List<String>> getReconAcctsMap(DynamicObject reconScheme) {
        DynamicObjectCollection shcemeEntry = reconScheme.getDynamicObjectCollection("modularentryentity");
        ArrayList<String> yzaccts = new ArrayList<String>(shcemeEntry.size());
        ArrayList<String> jzaccts = new ArrayList<String>(shcemeEntry.size());
        ArrayList<String> zjaccts = new ArrayList<String>(shcemeEntry.size());
        for (DynamicObject entryrow : shcemeEntry) {
            DynamicObjectCollection amounttypes = entryrow.getDynamicObjectCollection("amounttype");
            for (DynamicObject amounttype : amounttypes) {
                DynamicObject dyo = amounttype.getDynamicObject("fbasedataid");
                DynamicObjectCollection accounts = entryrow.getDynamicObjectCollection("accounts");
                DynamicObject account = accounts.size() > 0 ? ((DynamicObject)accounts.get(0)).getDynamicObject("fbasedataid") : entryrow.getDynamicObject("account");
                String name = dyo.getString("name");
                if (ResManager.loadKDString((String)"\u539f\u503c", (String)"FaCardRealExportExtHandle_7", (String)"fi-fea-business", (Object[])new Object[0]).equals(name)) {
                    yzaccts.add(account.getString("number"));
                    continue;
                }
                if (ResManager.loadKDString((String)"\u51cf\u503c\u51c6\u5907", (String)"FaCardRealExportExtHandle_8", (String)"fi-fea-business", (Object[])new Object[0]).equals(name)) {
                    jzaccts.add(account.getString("number"));
                    continue;
                }
                if (!ResManager.loadKDString((String)"\u7d2f\u8ba1\u6298\u65e7", (String)"FaCardRealExportExtHandle_9", (String)"fi-fea-business", (Object[])new Object[0]).equals(name)) continue;
                zjaccts.add(account.getString("number"));
            }
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("yz", yzaccts);
        map.put("jz", jzaccts);
        map.put("zz", zjaccts);
        return map;
    }

    private DynamicObject getReconScheme(long orgId, long booktype) {
        QFilter enable;
        QFilter qbizapp;
        QFilter qbooktype;
        QFilter quseorg = BaseDataServiceHelper.getBaseDataFilter((String)"ai_reconciliation_scheme", (Long)orgId);
        Map dyos = BusinessDataServiceHelper.loadFromCache((String)"ai_reconciliation_scheme", (QFilter[])new QFilter[]{quseorg, qbooktype = new QFilter("booktype", "=", (Object)booktype), qbizapp = new QFilter("bizapp.number", "=", (Object)"fa"), enable = new QFilter("enable", "=", (Object)true)});
        if (dyos != null && dyos.size() > 0) {
            return (DynamicObject)dyos.entrySet().iterator().next().getValue();
        }
        return null;
    }
}

