/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.ext;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DSField;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.AbstractExportExtHandle;
import kd.fi.fea.opservice.export.formula.IGetValueMode;
import kd.fi.fea.opservice.export.formula.IVariableMode;
import kd.fi.fea.opservice.export.formula.SourceBillFieldMode;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VoucherExportExtHandle
extends AbstractExportExtHandle {
    private static final Log log = LogFactory.getLog(VoucherExportExtHandle.class);
    private static final int FLEXFIELD_CAPACITY = 32;
    private static final int ASSGRP_CAPACITY = 1024;
    private static final int ASSGRP_NODE_COUNT = 30;
    protected Set<Long> curAssgrpIds;
    private Map<String, String> propAndFieldMap;
    private Map<String, String> propAndAliasMap;
    private Set<String> removeFields;
    private Map<String, String> typeIdAndNumMap;
    private Map<Long, Map<String, Integer>> accountAndFlexSeqMap;
    private StructureSingleExportContext context;
    private static final boolean isLogInfo = true;
    protected String comAssistField = null;
    protected Set<Long> comAssistValSet = new HashSet<Long>(1024);
    protected Map<Long, String> comAssistValMap = new HashMap<Long, String>(1024);

    protected String getComAssistFieldPrefix() {
        return "entries.";
    }

    protected void compiler(StructureSingleExportContext context) {
        this.context = context;
        this.curAssgrpIds = new HashSet<Long>(1024);
        this.propAndFieldMap = new HashMap<String, String>(32);
        this.initExtraPropAndFieldMap(this.propAndFieldMap);
        this.propAndAliasMap = new HashMap<String, String>(32);
        this.initExtraPropAndAliasMap(this.propAndAliasMap);
        this.removeFields = new HashSet<String>(32);
        this.addRemoveFields(this.removeFields);
        AccountBookInfo bookInfo = this.context.getSingleExportContext().getAcctBookInfo();
        this.initAccountInfo(bookInfo);
        DSField comAssist = bookInfo.getComAssist();
        if (comAssist != null && CollectionUtils.isNotEmpty((Collection)context.getExprotPlanInfo().getComAssistFilter())) {
            this.comAssistField = this.getComAssistFieldPrefix() + comAssist.getFieldKey();
        }
    }

    private void initAccountInfo(AccountBookInfo bookInfo) {
        QFilter actbleFilter = new QFilter("accounttable", "=", (Object)bookInfo.getAccountTableId());
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)this.context.getOrgId());
        QFilter assistfilter = new QFilter("isassist", "=", (Object)Boolean.TRUE);
        this.accountAndFlexSeqMap = new HashMap<Long, Map<String, Integer>>(1024);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_accountview", (String)"id, checkitementry.seq seq, checkitementry.asstactitem.flexfield flexfield", (QFilter[])new QFilter[]{actbleFilter, orgFilter, assistfilter}, (String)"id,checkitementry.seq");){
            for (Row row : dSet) {
                String flexField = row.getString("flexfield");
                if (StringUtils.isEmpty((CharSequence)flexField)) continue;
                Map seqMap = this.accountAndFlexSeqMap.computeIfAbsent(row.getLong("id"), p -> new LinkedHashMap());
                seqMap.put(flexField, row.getInteger("seq"));
            }
        }
    }

    @Override
    public String getSelectPropertis(StructureSingleExportContext context, String selectPropertis) {
        this.compiler(context);
        String entityName = context.getEntityName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        HashSet<String> sp = new HashSet<String>(mainEntityType.getProperties().size());
        this.addBillSpecialField(sp);
        if (this.comAssistField != null) {
            sp.add(this.comAssistField);
        }
        for (DataStructureEntryExportPlanModel structureEntry : context.getTreeEntryEntity()) {
            String formula;
            String sourcetpye;
            Map valueMap = structureEntry.getValueMap();
            if (valueMap == null || !"2".equals(sourcetpye = (String)valueMap.get("sourcetype")) || this.removeFields.contains(formula = (String)valueMap.get("value"))) continue;
            String selectField = this.propAndFieldMap.get(formula);
            if (StringUtils.isEmpty((CharSequence)selectField)) {
                IGetValueMode valueMode = context.getFormulaAndValueModeMap().get(formula);
                if (valueMode == null) continue;
                List<IVariableMode> vars = valueMode.getVars();
                for (IVariableMode var : vars) {
                    if (!(var instanceof SourceBillFieldMode)) continue;
                    SourceBillFieldMode srcBillFieldMode = (SourceBillFieldMode)var;
                    sp.add(srcBillFieldMode.getFullPropName());
                    context.getExpPropNameMap().put(var.getVar(), srcBillFieldMode.getFullPropName());
                }
                continue;
            }
            sp.add(selectField);
            String fullPropName = this.propAndAliasMap.get(formula);
            if (!StringUtils.isEmpty((CharSequence)fullPropName)) {
                context.getExpPropNameMap().put(formula, fullPropName);
                continue;
            }
            context.getExpPropNameMap().put(formula, selectField);
        }
        return String.join((CharSequence)",", sp);
    }

    @Override
    public Set<QFilter> getFilters(StructureSingleExportContext context, Set<QFilter> entryQFilters) {
        ExprotPlanInfo exportPlanInfo = context.getExprotPlanInfo();
        Set comAssistFilter = exportPlanInfo.getComAssistFilter();
        if (this.comAssistField == null || comAssistFilter == null || comAssistFilter.isEmpty()) {
            return entryQFilters;
        }
        entryQFilters.add(new QFilter(this.comAssistField, "in", (Object)comAssistFilter));
        return entryQFilters;
    }

    @Override
    public DataSet getDataSource(StructureSingleExportContext context, DataSet dataSet, Set<QFilter> originFilters) {
        String filetype = context.getExprotPlanInfo().getFiletype();
        DataSet ds = dataSet;
        if ("csv".equalsIgnoreCase(filetype)) {
            long orgId = context.getSingleExportContext().getOrgId();
            ExprotPlanInfo exportPlanInfo = context.getSingleExportContext().getExportContext().getExprotPlanInfo();
            AccountBookInfo bookInfo = context.getSingleExportContext().getAcctBookInfo();
            Long endPeriodId = exportPlanInfo.getEndperiodId();
            Map versionIdMap = AccountVersionUtil.getAccountVersionIdMap((long)orgId, (long)bookInfo.getAccountTableId(), (long)endPeriodId);
            if (!versionIdMap.isEmpty()) {
                Algo algo = Algo.create((String)VoucherExportExtHandle.class.getName());
                Field[] fields = new Field[]{new Field("oldid", (DataType)DataType.LongType), new Field("newid", (DataType)DataType.LongType)};
                DataSetBuilder builder = algo.createDataSetBuilder(new RowMeta(fields));
                versionIdMap.forEach((k, v) -> {
                    Object[] row = new Object[fields.length];
                    row[0] = k;
                    row[1] = v;
                    builder.append(row);
                });
                DataSet oldDataSet = builder.build();
                DataSet currDataSet = QueryServiceHelper.queryDataSet((String)VoucherExportExtHandle.class.getName(), (String)"bd_accountview", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", versionIdMap.values())}, null);
                DataSet idAndNumDataSet = oldDataSet.join(currDataSet).on("newid", "id").select(new String[]{"oldid", "number"}).finish();
                String[] leftFields = dataSet.getRowMeta().getFieldNames();
                ds = dataSet.leftJoin(idAndNumDataSet).on("entries.account", "oldid").select(leftFields, new String[]{"number rpt_acctnumber"}).finish();
                ds = ds.updateField("entries.account.number", "case when rpt_acctnumber = null then entries.account.number else rpt_acctnumber end");
            }
        }
        ds = ds.orderBy(new String[]{"period.id", "vouchertype.id", "billno", "id", "entries.seq"});
        AccountBookInfo accountBook = context.getSingleExportContext().getAcctBookInfo();
        DSField comAssist = accountBook.getComAssist();
        if (comAssist != null) {
            final RowMeta rowMeta = ds.getRowMeta();
            final int seqFieldIndex = rowMeta.getFieldIndex("entries.seq");
            ds = ds.map(new MapFunction(){
                long preVchId = 0L;
                int seqIndex = 1;

                public Object[] map(Row row) {
                    Long curVchId = row.getLong("id");
                    if (this.preVchId == 0L) {
                        this.preVchId = curVchId;
                    } else if (curVchId.compareTo(this.preVchId) != 0) {
                        this.preVchId = curVchId;
                        this.seqIndex = 1;
                    }
                    Object[] values = ((AbstractRow)row).values();
                    Object[] result = new Object[values.length];
                    for (int i = 0; i < result.length; ++i) {
                        result[i] = i == seqFieldIndex ? Integer.valueOf(this.seqIndex++) : values[i];
                    }
                    return result;
                }

                public RowMeta getResultRowMeta() {
                    return rowMeta;
                }
            });
        }
        return ds;
    }

    @Override
    public Object parseExpression(StructureSingleExportContext context, Row row, DataStructureEntryExportPlanModel structureEntry, ElementNodeInfo nodeInfo, Object elementValue) {
        if (null == structureEntry.getValueMap()) {
            return elementValue;
        }
        if (structureEntry.getElement().isAssistItem()) {
            Long assgrpId = Long.valueOf(elementValue.toString());
            nodeInfo.setAssgrpId(assgrpId);
            nodeInfo.setAssgrpIndex(structureEntry.getSeq());
            this.addCurAssgrpId(assgrpId);
            if (this.comAssistField != null && CollectionUtils.isNotEmpty((Collection)context.getExprotPlanInfo().getComAssistFilter())) {
                Long comAssistVal = row.getLong(this.comAssistField);
                this.comAssistValSet.add(comAssistVal);
                nodeInfo.setComAssistVal(comAssistVal);
            }
        } else {
            String propName;
            Map valueMap = structureEntry.getValueMap();
            switch (propName = (String)valueMap.get("value")) {
                case "account.number": {
                    Long accountId = row.getLong("entries.account");
                    nodeInfo.setAccountId(accountId);
                    break;
                }
            }
        }
        return elementValue;
    }

    protected void addCurAssgrpId(Long assgrpId) {
        if (assgrpId == null || assgrpId == 0L) {
            return;
        }
        if (this.curAssgrpIds.contains(assgrpId)) {
            return;
        }
        this.curAssgrpIds.add(assgrpId);
    }

    @Override
    public List<Element> buildElement(StructureSingleExportContext context, List<Element> elements, List<ElementNodeInfo> nodeInfos) {
        if (!this.curAssgrpIds.isEmpty()) {
            this.typeIdAndNumMap = new HashMap<String, String>(1024);
        }
        this.buildAssgrpMapInfo(this.curAssgrpIds, nodeInfos);
        if (this.comAssistField != null) {
            this.comAssistValMap.clear();
            AccountBookInfo acctBookInfo = context.getSingleExportContext().getAcctBookInfo();
            DSField comAssist = acctBookInfo.getComAssist();
            String dataType = comAssist.getDataType();
            Map comAssists = BusinessDataServiceHelper.loadFromCache((String)comAssist.getEntityId(), (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", this.comAssistValSet)});
            for (Map.Entry assistRow : comAssists.entrySet()) {
                DynamicObject rowDyn = (DynamicObject)assistRow.getValue();
                this.comAssistValMap.put(rowDyn.getLong("id"), rowDyn.getString("number"));
            }
            this.comAssistValSet.clear();
        }
        this.curAssgrpIds.clear();
        ArrayList<Element> elementList = new ArrayList<Element>(10);
        for (ElementNodeInfo nodeInfo : nodeInfos) {
            Element element = DocumentHelper.createElement((String)context.getBillName());
            int assgrpIndex = nodeInfo.getAssgrpIndex() - 1;
            int index = 0;
            for (Map.Entry entry : nodeInfo.getAllNodes().entrySet()) {
                if (index == assgrpIndex) {
                    this.addAssgrpElement(nodeInfo, element, index);
                } else {
                    element.addElement((String)entry.getKey()).setText((String)entry.getValue());
                }
                ++index;
            }
            elementList.add(element);
        }
        return elementList;
    }

    private void buildAssgrpMapInfo(Set<Long> assgrpIds, List<ElementNodeInfo> nodeInfos) {
        Map<String, List<Long>> flexNumAndDetailIdMap = this.getFlexNumAndDetailIdMap(assgrpIds, nodeInfos);
        Map<String, String> flexFieldAndEntityNameMap = this.getFlexFieldAndEntityNameMap(flexNumAndDetailIdMap.keySet());
        this.buildTypeIdAndNumMap(flexNumAndDetailIdMap, flexFieldAndEntityNameMap);
    }

    private void buildTypeIdAndNumMap(Map<String, List<Long>> flexNumAndDetailIdMap, Map<String, String> flexFieldAndEntityNameMap) {
        for (Map.Entry<String, List<Long>> entry : flexNumAndDetailIdMap.entrySet()) {
            String flexNum = entry.getKey();
            String entityName = flexFieldAndEntityNameMap.get(flexNum);
            if (StringUtils.isEmpty((CharSequence)entityName)) continue;
            List<Long> detailIds = entry.getValue();
            DataSet flexItemSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "writeContent"), (String)entityName, (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", detailIds)}, null);
            Throwable throwable = null;
            try {
                for (Row row : flexItemSet) {
                    Long id = row.getLong("id");
                    this.typeIdAndNumMap.put(ElementNodeInfo.getTypeAndIdKey((String)flexNum, (Long)id), row.getString("number"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (flexItemSet == null) continue;
                if (throwable != null) {
                    try {
                        flexItemSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                flexItemSet.close();
            }
        }
    }

    private Map<String, String> getFlexFieldAndEntityNameMap(Set<String> flexFields) {
        HashMap<String, String> flexNumAndEntityNameMap = new HashMap<String, String>(32);
        try (DataSet itemSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "writeContent"), (String)"bd_asstacttype", (String)"valuesource, flexfield, index", (QFilter[])new QFilter[]{new QFilter("flexfield", "in", flexFields)}, null);){
            for (Row row : itemSet) {
                String flexField = row.getString("flexfield");
                flexNumAndEntityNameMap.put(flexField, row.getString("valuesource"));
            }
        }
        return flexNumAndEntityNameMap;
    }

    private Map<String, List<Long>> getFlexNumAndDetailIdMap(Set<Long> assgrpIds, List<ElementNodeInfo> nodeInfos) {
        HashMap<String, List<Long>> flexNumAndDetailIdMap = new HashMap<String, List<Long>>(32);
        HashMap<Long, List<ElementNodeInfo>> assgrpAndNodesMap = new HashMap<Long, List<ElementNodeInfo>>(nodeInfos.size());
        for (ElementNodeInfo nodeInfo : nodeInfos) {
            if (nodeInfo.getAssgrpId() == null || Long.valueOf(0L).compareTo(nodeInfo.getAssgrpId()) == 0) continue;
            List tmpNodes = assgrpAndNodesMap.computeIfAbsent(nodeInfo.getAssgrpId(), p -> new ArrayList());
            tmpNodes.add(nodeInfo);
        }
        this.updateTypeAndValMap("gl_assist_bd", assgrpIds, flexNumAndDetailIdMap, assgrpAndNodesMap);
        this.updateTypeAndValMap("gl_assist_txt", assgrpIds, flexNumAndDetailIdMap, assgrpAndNodesMap);
        return flexNumAndDetailIdMap;
    }

    private void updateTypeAndValMap(String entityName, Set<Long> assgrpIds, Map<String, List<Long>> flexNumAndDetailIdMap, Map<Long, List<ElementNodeInfo>> assgrpAndNodesMap) {
        try (DataSet assgrpSet = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + "writeContent"), (String)entityName, (String)"hg, asstype, assval", (QFilter[])new QFilter[]{new QFilter("hg", "in", assgrpIds)}, null);){
            for (Row row : assgrpSet) {
                Long assgrpId = row.getLong("hg");
                String asstype = row.getString("asstype");
                Object assval = row.get("assval");
                List<ElementNodeInfo> tmpNodes = assgrpAndNodesMap.get(assgrpId);
                if (tmpNodes != null) {
                    for (ElementNodeInfo nodeInfo : tmpNodes) {
                        nodeInfo.addFlexItemTypeAndVal(asstype, assval);
                    }
                }
                if (!"gl_assist_bd".equals(entityName)) continue;
                List detailIds = flexNumAndDetailIdMap.computeIfAbsent(asstype, p -> new ArrayList());
                detailIds.add(Long.valueOf(assval.toString()));
            }
        }
    }

    protected void addRemoveFields(Set<String> removeFields) {
    }

    protected void addBillSpecialField(Set<String> sp) {
        sp.add("id");
        sp.add("bookeddate");
        sp.add("billno");
        sp.add("entries.seq");
        sp.add("entries.account");
        sp.add("vouchertype.id");
        sp.add("period.id");
    }

    protected void initExtraPropAndFieldMap(Map<String, String> map) {
        map.put("seq", "entries.seq");
    }

    protected void initExtraPropAndAliasMap(Map<String, String> map) {
    }

    private void addAssgrpElement(ElementNodeInfo nodeInfo, Element element, int nodeIndex) {
        Map<String, Integer> flexTypeAndSeqMap;
        List<DataStructureEntryExportPlanModel> treeEntries = this.context.getTreeEntryEntity();
        if (nodeIndex >= treeEntries.size()) {
            this.logInfo(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%1$s\u7279\u6b8a\u5904\u7406\u65f6\uff0c\u8bfb\u53d6\u6570\u636e\u7ed3\u6784\u8282\u70b9\u8d8a\u754c\uff0c\u7d22\u5f15\u503c%2$s\uff0c\u5b9e\u9645\u5927\u5c0f%3$s", (String)"VoucherExportExtHandle_3", (String)"fi-fea-business", (Object[])new Object[0]), nodeInfo.getAssgrpId(), nodeIndex, treeEntries.size()));
            return;
        }
        DataStructureEntryExportPlanModel assistNode = treeEntries.get(nodeIndex);
        Long accountId = nodeInfo.getAccountId();
        if (accountId == null) {
            this.logInfo(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6%s\u7279\u6b8a\u5904\u7406\u65f6\uff0c\u8bfb\u53d6\u79d1\u76ee\u4fe1\u606f\u5931\u8d25", (String)"VoucherExportExtHandle_1", (String)"fi-fea-business", (Object[])new Object[0]), nodeInfo.getAssgrpId(), nodeIndex, treeEntries.size()));
            this.addNullAssgrpNodes(element, 0, assistNode);
            return;
        }
        int assistIndex = 0;
        if (this.comAssistField != null) {
            Long comAssistVal = nodeInfo.getComAssistVal();
            String comAssistNumber = this.comAssistValMap.get(comAssistVal);
            if (comAssistNumber != null) {
                element.addElement(assistNode.getElement().getAssistNodeName(assistIndex + 1)).setText(comAssistNumber);
            }
            ++assistIndex;
        }
        if ((flexTypeAndSeqMap = this.accountAndFlexSeqMap.get(accountId)) == null) {
            this.addNullAssgrpNodes(element, assistIndex, assistNode);
            return;
        }
        Map flexItemTypeIdMap = nodeInfo.getFlexItemTypeValMap();
        if (flexItemTypeIdMap.isEmpty()) {
            this.addNullAssgrpNodes(element, assistIndex, assistNode);
            return;
        }
        ArrayList<String> flexItemTypes = new ArrayList<String>(flexTypeAndSeqMap.keySet());
        Collections.sort(flexItemTypes, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer seq1 = (Integer)flexTypeAndSeqMap.get(o1);
                Integer seq2 = (Integer)flexTypeAndSeqMap.get(o2);
                if (seq1 != null && seq2 != null) {
                    return seq1.compareTo(seq2);
                }
                return 0;
            }
        });
        int actAssgrpCount = flexItemTypes.size();
        if (actAssgrpCount > 30) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u79d1\u76ee%1$s\u6838\u7b97\u7ef4\u5ea6\u6570\u91cf\u5927\u4e8e\u6570\u636e\u7ed3\u6784\u914d\u7f6e\u7684\u9650\u5236\u5927\u5c0f%2$s", (String)"VoucherExportExtHandle_4", (String)"fi-fea-business", (Object[])new Object[0]), accountId, 30));
        }
        for (String flexItemType : flexItemTypes) {
            Integer flexSeq = flexTypeAndSeqMap.get(flexItemType);
            if (flexSeq == null) continue;
            Object val = flexItemTypeIdMap.get(flexItemType);
            if (val == null) {
                element.addElement(assistNode.getElement().getAssistNodeName(assistIndex + 1)).clearContent();
            } else if (val instanceof Long) {
                String key = ElementNodeInfo.getTypeAndIdKey((String)flexItemType, (Long)((Long)val));
                String number = this.typeIdAndNumMap.get(key);
                if (!StringUtils.isEmpty((CharSequence)number)) {
                    element.addElement(assistNode.getElement().getAssistNodeName(assistIndex + 1)).setText(number);
                } else {
                    element.addElement(assistNode.getElement().getAssistNodeName(assistIndex + 1)).setText(val.toString());
                }
            } else {
                element.addElement(assistNode.getElement().getAssistNodeName(assistIndex + 1)).setText(val.toString());
            }
            ++assistIndex;
        }
        this.addNullAssgrpNodes(element, assistIndex, assistNode);
    }

    public int addNullAssgrpNodes(Element element, int index, DataStructureEntryExportPlanModel assistNode) {
        while (index < 30) {
            element.addElement(assistNode.getElement().getAssistNodeName(index + 1)).clearContent();
            ++index;
        }
        return index;
    }

    protected void logInfo(String msg) {
        log.info("\u5916\u90e8\u5ba1\u8ba1\u5bfc\u51fa\uff1a" + msg);
    }
}

