/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.format;

import java.text.SimpleDateFormat;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fea.model.DataType;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.builder.format.IDataFormatHandle;

public class DateValueFormatHandle
extends AbstractDataFormatHandle {
    private static final Log logger = LogFactory.getLog(DateValueFormatHandle.class);

    public DateValueFormatHandle(DataType dataType, Object fieldValue) {
        super(dataType, fieldValue);
    }

    @Override
    public IDataFormatHandle compile() {
        if (null == this.fieldValue || "".equals(this.fieldValue)) {
            return this;
        }
        String formatter = this.dataType.getFormatter();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(formatter);
        try {
            if (this.fieldValue instanceof String) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.fieldValue = format.parse((String)this.fieldValue);
            }
            this.fieldValue = simpleDateFormat.format(this.fieldValue);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return this;
    }
}

