/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.fi.fea.model.DataType;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.builder.format.IDataFormatHandle;

public class DecimalValueFormatToStringHandle
extends AbstractDataFormatHandle {
    public DecimalValueFormatToStringHandle(DataType dataType, Object fieldValue) {
        super(dataType, fieldValue);
    }

    @Override
    public IDataFormatHandle compile() {
        if (null == this.fieldValue || "".equals(this.fieldValue)) {
            return this;
        }
        Integer totalLe = this.dataType.getTotallength();
        Integer decimalLe = this.dataType.getDecimallength();
        BigDecimal number = null;
        if (this.fieldValue instanceof Number) {
            if (this.fieldValue instanceof BigDecimal) {
                number = (BigDecimal)this.fieldValue;
            } else if (this.fieldValue instanceof BigInteger) {
                number = new BigDecimal((BigInteger)this.fieldValue);
            } else {
                double value = ((Number)this.fieldValue).doubleValue();
                number = BigDecimal.valueOf(value);
            }
        } else if (this.fieldValue instanceof String) {
            number = new BigDecimal((String)this.fieldValue);
        }
        if (null == number) {
            return this;
        }
        this.fieldValue = number.setScale((int)decimalLe, 4);
        if (number.toString().length() > totalLe) {
            StringBuilder stringBuilder = new StringBuilder(number.toString());
            String substring = stringBuilder.reverse().substring(0, totalLe);
            stringBuilder = new StringBuilder(substring);
            substring = stringBuilder.reverse().toString();
            this.fieldValue = new BigDecimal(substring);
        }
        return this;
    }
}

