/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.format;

import java.math.BigInteger;
import kd.fi.fea.model.DataType;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.builder.format.IDataFormatHandle;

public class ShortValueFormatToStringHandle
extends AbstractDataFormatHandle {
    public ShortValueFormatToStringHandle(DataType dataType, Object fieldValue) {
        super(dataType, fieldValue);
    }

    @Override
    public IDataFormatHandle compile() {
        if (null == this.fieldValue || "".equals(this.fieldValue)) {
            return this;
        }
        Integer totalLe = this.dataType.getIntegerlength();
        BigInteger number = null;
        if (this.fieldValue instanceof Number) {
            if (this.fieldValue instanceof BigInteger) {
                number = (BigInteger)this.fieldValue;
            } else {
                long value = ((Number)this.fieldValue).longValue();
                number = BigInteger.valueOf(value);
            }
        } else if (this.fieldValue instanceof String) {
            number = new BigInteger((String)this.fieldValue);
        }
        this.fieldValue = number;
        String value = String.valueOf(number);
        if (value.length() > totalLe) {
            StringBuilder stringBuilder = new StringBuilder(value);
            String substring = stringBuilder.reverse().substring(0, totalLe);
            this.fieldValue = new BigInteger(substring);
        }
        return this;
    }
}

