/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.getFilterHandle;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fea.cache.AppBookConfig;
import kd.fi.fea.cache.FeaCache;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.getFilterHandle.AbstractGetFilterHandle;

public class BizBookFilterHandle
extends AbstractGetFilterHandle {
    private int propType = 0;

    public BizBookFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        super(singleExportContext, entity, propName);
    }

    @Override
    public AbstractGetFilterHandle compile() {
        this.qFilters.add(this.getBizBookFilter());
        return this;
    }

    @Override
    public String findDefaultProperty() {
        if ("fa_change_dept".equals(this.entity)) {
            return "fieldentry.fincard1.depreuse";
        }
        String appNumber = FeaCache.getBillEntityAppNumber((String)this.entity);
        if (FeaCache.getAppConfig().containsKey(appNumber)) {
            AppBookConfig abCfg = (AppBookConfig)FeaCache.getAppConfig().get(appNumber);
            if (StringUtils.isNotEmpty((String)abCfg.bookEntityTypeField)) {
                String billBookTypeField = FeaCache.getBillBookTypeField((String)this.entity);
                if (StringUtils.isNotEmpty((String)billBookTypeField)) {
                    this.propName = billBookTypeField;
                    this.propType = 2;
                }
            } else {
                String billBookField = FeaCache.getBillBookField((String)this.entity);
                if (StringUtils.isNotEmpty((String)billBookField)) {
                    this.propName = billBookField;
                    this.propType = 1;
                }
            }
        }
        return this.propName;
    }

    private QFilter getBizBookFilter() {
        QFilter acctFilter = null;
        String appNumber = FeaCache.getBillEntityAppNumber((String)this.entity);
        if (FeaCache.getAppConfig().containsKey(appNumber)) {
            AppBookConfig abCfg = (AppBookConfig)FeaCache.getAppConfig().get(appNumber);
            Set<Long> bizBookIDs = this.getBizBookIDs(abCfg.acctBookEnryTableName, this.singleExportContext.getAcctBookId());
            if (!bizBookIDs.isEmpty()) {
                if (this.propType == 2) {
                    Map bizBooks = BusinessDataServiceHelper.loadFromCache((String)abCfg.bookEntity, (String)abCfg.bookEntityTypeField, (QFilter[])new QFilter[]{new QFilter("id", "in", bizBookIDs)});
                    HashSet<Long> bizBookTypes = new HashSet<Long>(bizBooks.size());
                    for (DynamicObject bizBook : bizBooks.values()) {
                        bizBookTypes.add(bizBook.getLong(abCfg.bookEntityTypeField + ".id"));
                    }
                    acctFilter = new QFilter(this.propName, "in", bizBookTypes);
                } else if (this.propType == 1) {
                    acctFilter = new QFilter(this.propName, "in", bizBookIDs);
                }
            } else if (this.propType == 1) {
                acctFilter = new QFilter(this.propName, "=", (Object)0L);
            } else if (this.propType == 2) {
                acctFilter = new QFilter(this.propName, "=", (Object)0L);
            }
        }
        return acctFilter;
    }

    private Set<Long> getBizBookIDs(String entryTable, long accBookID) {
        String key = entryTable + accBookID;
        Set idSet = FeaCache.getBizBookIds((String)key);
        if (idSet == null) {
            idSet = (Set)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)("select fbasedataid from " + entryTable + " where fid = ?"), (Object[])new Object[]{accBookID}, e -> {
                HashSet<Long> res = new HashSet<Long>(16);
                while (e.next()) {
                    long fid = e.getLong("fbasedataid");
                    res.add(fid);
                }
                return res;
            });
            FeaCache.setBizBookIds((String)key, (Set)idSet);
        }
        return idSet;
    }
}

