/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.builder.selectprop;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.formula.FormulaMode;
import kd.fi.fea.opservice.export.formula.IGetValueMode;
import kd.fi.fea.opservice.export.formula.IVariableMode;
import kd.fi.fea.opservice.export.formula.SourceBillFieldMode;

public class GetSelectPropertisHandle {
    private static final Log log = LogFactory.getLog(GetSelectPropertisHandle.class);
    protected StructureSingleExportContext context;
    private Map<String, IGetValueMode> formulaAndValueModeMap;

    public GetSelectPropertisHandle(StructureSingleExportContext context) {
        this.context = context;
    }

    public String getSelectPropertis() {
        this.complie(this.context);
        String entityName = this.context.getEntityName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityName);
        HashSet<String> sp = new HashSet<String>(mainEntityType.getProperties().size());
        sp.add(mainEntityType.getPrimaryKey().getName());
        for (DataStructureEntryExportPlanModel structureEntry : this.getTreeEntryEntity()) {
            String sourcetpye;
            Map valueMap = structureEntry.getValueMap();
            if (valueMap == null || !"2".equals(sourcetpye = (String)valueMap.get("sourcetype"))) continue;
            String formula = (String)valueMap.get("value");
            if (StringUtils.isNotEmpty((CharSequence)formula) && formula.endsWith("seq")) {
                sp.add(formula);
                continue;
            }
            IGetValueMode valueMode = this.getValueMode(formula);
            if (valueMode == null) continue;
            List<IVariableMode> vars = valueMode.getVars();
            for (IVariableMode var : vars) {
                if (!(var instanceof SourceBillFieldMode)) continue;
                SourceBillFieldMode srcBillFieldMode = (SourceBillFieldMode)var;
                sp.add(srcBillFieldMode.getFullPropName());
                this.getExpPropNameMap().put(var.getVar(), srcBillFieldMode.getFullPropName());
            }
        }
        return String.join((CharSequence)",", sp);
    }

    protected Map<String, String> getExpPropNameMap() {
        if (this.context.getExpPropNameMap() == null) {
            int capacity = this.context.getTreeEntryEntity() == null ? 32 : this.context.getTreeEntryEntity().size();
            this.context.setExpPropNameMap(new HashMap<String, String>(capacity));
        }
        return this.context.getExpPropNameMap();
    }

    protected List<DataStructureEntryExportPlanModel> getTreeEntryEntity() {
        return this.context.getTreeEntryEntity();
    }

    public void complie(StructureSingleExportContext context) {
        this.initFormulaModes();
    }

    private void initFormulaModes() {
        this.formulaAndValueModeMap = new HashMap<String, IGetValueMode>();
        for (DataStructureEntryExportPlanModel structureEntry : this.context.getTreeEntryEntity()) {
            String sourcetpye;
            Map valueMap = structureEntry.getValueMap();
            if (valueMap == null || !"2".equals(sourcetpye = (String)valueMap.get("sourcetype"))) continue;
            String formula = (String)valueMap.get("value");
            this.formulaAndValueModeMap.computeIfAbsent(formula, p -> new FormulaMode(this.context.getEntityType(), formula));
        }
    }

    protected IGetValueMode getValueMode(String formula) {
        return this.formulaAndValueModeMap.get(formula);
    }
}

