/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.factory;

import kd.fi.fea.enums.datatype.DataTypeEnum;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.DataType;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.builder.format.AnyUriValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.DateValueFormatHandle;
import kd.fi.fea.opservice.export.builder.format.DecimalValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.DoubleValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.IntegerValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.NonNegativeIntegerValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.ShortValueFormatToStringHandle;
import kd.fi.fea.opservice.export.builder.format.StringValueFormatHandle;
import kd.fi.fea.opservice.export.builder.format.TimeValueFormatHandle;

public class DataFormatHandleFactory {
    public static AbstractDataFormatHandle getDataFormatHandle(DataStructureEntryExportPlanModel structureEntry, Object elementValue) {
        AbstractDataFormatHandle handle = null;
        DataType dataType = structureEntry.getElement().getDataType();
        String type = dataType.getType();
        if (DataTypeEnum.DATE.getValue().equals(type)) {
            handle = new DateValueFormatHandle(dataType, elementValue);
        } else if (DataTypeEnum.TIME.getValue().equals(type)) {
            handle = new TimeValueFormatHandle(dataType, elementValue);
        } else if (DataTypeEnum.STRING.getValue().equals(type)) {
            handle = new StringValueFormatHandle(dataType, elementValue);
        } else if (DataTypeEnum.ANYURI.getValue().equals(type)) {
            handle = new AnyUriValueFormatToStringHandle(dataType, elementValue);
        } else if (DataTypeEnum.DOUBLE.getValue().equals(type)) {
            handle = new DoubleValueFormatToStringHandle(dataType, elementValue);
        } else if (DataTypeEnum.DECIMAL.getValue().equals(type)) {
            handle = new DecimalValueFormatToStringHandle(dataType, elementValue);
        } else if (DataTypeEnum.INT.getValue().equals(type)) {
            handle = new IntegerValueFormatToStringHandle(dataType, elementValue);
        } else if (DataTypeEnum.NONNEGATIVEINTEGER.getValue().equals(type)) {
            handle = new NonNegativeIntegerValueFormatToStringHandle(dataType, elementValue);
        } else if (DataTypeEnum.SHORT.getValue().equals(type)) {
            handle = new ShortValueFormatToStringHandle(dataType, elementValue);
        }
        return handle;
    }
}

