/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.factory;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.util.StringUtils;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.getFilterHandle.AbstractGetFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.AcctBookFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.BaseDataFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.BillStatusFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.BizBookFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.BizDateFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.IGetFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.OrgFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.PeriodFilterHandle;
import kd.fi.fea.opservice.export.builder.getFilterHandle.PeriodTypeFilterHandle;
import kd.fi.fea.opservice.export.helper.BillStatusPropHelper;
import kd.fi.fea.opservice.export.helper.PeriodTypePropHelper;

public class FilterHandleFactory {
    public static List<IGetFilterHandle> getCommonFilterHandle(String entity, String commonfilter, FileSingleExportContext singleExportContext) {
        IGetFilterHandle bookFilterHandle;
        IGetFilterHandle statusFilterHandle;
        ArrayList<IGetFilterHandle> handles = new ArrayList<IGetFilterHandle>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (entityType instanceof BasedataEntityType) {
            handles.add(new BaseDataFilterHandle(singleExportContext, entity, null));
        } else if (entityType instanceof BillEntityType && null != (statusFilterHandle = FilterHandleFactory.getStatusFilterHandle(singleExportContext, entity, null))) {
            handles.add(statusFilterHandle);
        }
        IGetFilterHandle periodTypeFilterHandle = FilterHandleFactory.getPeriodTypeFilterHandle(singleExportContext, entity, null);
        if (null != periodTypeFilterHandle) {
            handles.add(periodTypeFilterHandle);
        }
        if (null != (bookFilterHandle = FilterHandleFactory.getAcctBookFilterHandle(singleExportContext, entity))) {
            handles.add(bookFilterHandle);
        }
        if (StringUtils.isEmpty((String)commonfilter)) {
            return handles;
        }
        JSONObject valueMap = JSONObject.parseObject((String)commonfilter);
        String bizOrg = (String)valueMap.get("bizorg");
        String bizdate = (String)valueMap.get("bizdate");
        String period = (String)valueMap.get("period");
        IGetFilterHandle orgFilterHandle = FilterHandleFactory.getOrgFilterHandle(singleExportContext, entity, bizOrg);
        if (null != orgFilterHandle) {
            handles.add(orgFilterHandle);
        }
        IGetFilterHandle periodFilterHandle = null;
        if (!"null".equalsIgnoreCase(period) && StringUtils.isNotEmpty((String)period)) {
            periodFilterHandle = FilterHandleFactory.getPeriodFilterHandle(singleExportContext, entity, period);
        } else if (!"null".equalsIgnoreCase(bizdate) && StringUtils.isNotEmpty((String)bizdate)) {
            periodFilterHandle = FilterHandleFactory.getBizdateFilterHandle(singleExportContext, entity, bizdate);
        }
        if (null != periodFilterHandle) {
            handles.add(periodFilterHandle);
        }
        return handles;
    }

    public static IGetFilterHandle getOrgFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        OrgFilterHandle handle = null;
        if (StringUtils.isNotEmpty((String)propName)) {
            handle = new OrgFilterHandle(singleExportContext, entity, propName);
        }
        return handle;
    }

    public static IGetFilterHandle getPeriodFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        PeriodFilterHandle handle = null;
        if (StringUtils.isNotEmpty((String)propName)) {
            handle = new PeriodFilterHandle(singleExportContext, entity, propName);
        }
        return handle;
    }

    public static IGetFilterHandle getBizdateFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        BizDateFilterHandle handle = null;
        if (StringUtils.isNotEmpty((String)propName)) {
            handle = new BizDateFilterHandle(singleExportContext, entity, propName);
        }
        return handle;
    }

    public static IGetFilterHandle getAcctBookFilterHandle(FileSingleExportContext singleExportContext, String entity) {
        AbstractGetFilterHandle handle = null;
        handle = new AcctBookFilterHandle(singleExportContext, entity, null);
        String defaultProperty = handle.findDefaultProperty();
        if (null != defaultProperty) {
            return handle;
        }
        handle = new BizBookFilterHandle(singleExportContext, entity, null);
        defaultProperty = handle.findDefaultProperty();
        if (null != defaultProperty) {
            return handle;
        }
        return handle;
    }

    public static IGetFilterHandle getPeriodTypeFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        IDataEntityProperty defaultProperty;
        PeriodTypeFilterHandle handle = null;
        if (StringUtils.isEmpty((String)propName) && null != (defaultProperty = new PeriodTypePropHelper(entity).findDefaultProperty())) {
            propName = defaultProperty.getName();
        }
        if (StringUtils.isNotEmpty((String)propName)) {
            handle = new PeriodTypeFilterHandle(singleExportContext, entity, propName);
        }
        return handle;
    }

    public static IGetFilterHandle getStatusFilterHandle(FileSingleExportContext singleExportContext, String entity, String propName) {
        IDataEntityProperty defaultProperty;
        BillStatusFilterHandle handle = null;
        if (StringUtils.isEmpty((String)propName) && null != (defaultProperty = new BillStatusPropHelper(entity).findDefaultProperty())) {
            propName = defaultProperty.getName();
        }
        if (StringUtils.isNotEmpty((String)propName)) {
            handle = new BillStatusFilterHandle(singleExportContext, entity, propName);
        }
        return handle;
    }
}

