/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.factory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.ext.KsJavaPluginExtHandle;
import kd.fi.fea.opservice.export.builder.ext.KsPluginExtHandle;

public class GetExportExtHandleFactory {
    public static List<IExportExtHandle> getExtPluginHandle(FileSingleExportContext context, String entityName) {
        ArrayList handles = context.getHandles().get(entityName);
        return handles == null ? new ArrayList(1) : handles;
    }

    public static Map<String, List<IExportExtHandle>> getExtPluginHandle(Map<String, Map<String, String>> entityPluginMap) {
        HashMap<String, List<IExportExtHandle>> handleMap = new HashMap<String, List<IExportExtHandle>>(6);
        for (Map.Entry<String, Map<String, String>> entry : entityPluginMap.entrySet()) {
            ArrayList<Object> handleList = new ArrayList<Object>(5);
            Map<String, String> typePluginMap = entry.getValue();
            for (Map.Entry<String, String> typeEntry : typePluginMap.entrySet()) {
                String type;
                switch (type = typeEntry.getKey()) {
                    case "java": {
                        handleList.add(TypesContainer.createInstance((String)typeEntry.getValue()));
                        break;
                    }
                    case "ks": {
                        KsPluginExtHandle handle = new KsPluginExtHandle(typeEntry.getValue());
                        handleList.add(handle);
                        break;
                    }
                    case "ksjava": {
                        KsJavaPluginExtHandle kshandle = new KsJavaPluginExtHandle(typeEntry.getValue());
                        handleList.add(kshandle);
                        break;
                    }
                }
            }
            handleMap.put(entry.getKey(), handleList);
        }
        return handleMap;
    }

    public static Map<String, Map<String, String>> getExtPluginHandleConfig(String fileType) {
        HashSet<String> fileTypes = new HashSet<String>(2);
        fileTypes.add("2");
        fileTypes.add(FileTypeEnum.valueOf((String)fileType).getValue());
        QFilter qFilter = new QFilter("entryentity.filetype", "in", fileTypes);
        QFilter[] qFilters = new QFilter[]{qFilter};
        StringBuilder selectPropertiesSP = new StringBuilder();
        selectPropertiesSP.append("entity").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("seq").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("plugin").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("enable").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("pluginvalue").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("type").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("filetype").append(',');
        selectPropertiesSP.append("entryentity").append('.').append("number");
        String selectProperties = selectPropertiesSP.toString();
        Map plugObjMap = BusinessDataServiceHelper.loadFromCache((String)"fea_exportpluginconfig", (String)selectProperties, (QFilter[])qFilters);
        if (null == plugObjMap) {
            return new HashMap<String, Map<String, String>>(1);
        }
        HashMap<String, Map<String, String>> entityPluginMap = new HashMap<String, Map<String, String>>(6);
        for (DynamicObject plugObj : plugObjMap.values()) {
            String entityName = plugObj.getString("entity.number");
            HashMap<String, String> typePluginMap = new HashMap<String, String>();
            DynamicObjectCollection entryentity = plugObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : entryentity) {
                String type;
                boolean enable = row.getBoolean("enable");
                String entryFileType = row.getString("filetype");
                if (!enable || !fileTypes.contains(entryFileType)) continue;
                switch (type = row.getString("type")) {
                    case "java": {
                        typePluginMap.put(type, row.getString("plugin"));
                        break;
                    }
                    case "ks": {
                        typePluginMap.put(type, row.getString("pluginvalue"));
                        break;
                    }
                    case "ksjava": {
                        typePluginMap.put(type, row.getString("pluginvalue"));
                        break;
                    }
                }
            }
            entityPluginMap.put(entityName, typePluginMap);
        }
        return entityPluginMap;
    }
}

