/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.formula;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.Visitor;
import kd.fi.fea.opservice.export.formula.IGetValueMode;
import kd.fi.fea.opservice.export.formula.IVariableMode;
import kd.fi.fea.opservice.export.formula.SourceBillFieldMode;
import kd.fi.fea.opservice.export.formula.UnknownVariableMode;

public class FormulaMode<T>
implements IGetValueMode {
    private String formula;
    private final List<IVariableMode> vars = new ArrayList<IVariableMode>();
    private Expr expr;
    private final MainEntityType mainEntityType;

    public FormulaMode(MainEntityType entityType, String formula) {
        this.mainEntityType = entityType;
        this.setFormula(formula);
    }

    private void setFormula(String formula) {
        this.CompileFormula(formula);
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public List<IVariableMode> getVars() {
        return this.vars;
    }

    @Override
    public Object GetValue(Map<String, String> fldProperties, Row sourceRow) {
        Map<String, Object> ctx = this.getVarValues(fldProperties, sourceRow);
        Object v = FormulaEngine.execExcelFormula((Expr)this.expr, ctx, null);
        return v;
    }

    protected Map<String, Object> getVarValues(Map<String, String> fldProperties, Row row) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (IVariableMode var : this.getVars()) {
            String fieldName = fldProperties.get(var.getVar());
            if (fieldName == null) {
                ctx.put(var.getVar(), var.getValue(var.getVar(), row));
                continue;
            }
            Object item = row.get(fieldName);
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    protected void CompileFormula(String formula) {
        this.formula = formula;
        if (kd.bos.util.StringUtils.isEmpty((String)formula)) {
            return;
        }
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            this.expr = FormulaEngine.parseFormula((String)this.formula);
            UDFunctionVisitor mainEntityType = new UDFunctionVisitor();
            this.expr.accept((Visitor)mainEntityType);
        }
        catch (Throwable exp) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%2$s", (String)"FormulaMode_0", (String)"fi-fea-business", (Object[])new Object[0]), this.formula, exp.getMessage()));
        }
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            IVariableMode var = this.buildVarMode(this.mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    protected IVariableMode buildVarMode(MainEntityType mainEntityType, String varString, String[] keyItems) {
        SourceBillFieldMode var = null;
        IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
        if (property == null && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        var = property != null ? new SourceBillFieldMode(varString, keyItems, property) : new UnknownVariableMode(varString, keyItems);
        return var;
    }
}

