/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.processor;

import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fea.model.ExportPlanStandardInfo;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.GenerateExportPlanQFilters;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.selectprop.GetSelectPropertisHandle;
import kd.fi.fea.opservice.export.factory.GetExportExtHandleFactory;
import kd.fi.fea.opservice.export.factory.GetFileWriteFactory;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.writer.IExportWrite;

public abstract class AbstractExportProcessor {
    protected String packagePath;
    protected DynamicObject standardInfo;
    protected PlanInfo planInfo;
    protected FileSingleExportContext singleExportContext;

    protected AbstractExportProcessor(String packagePath, PlanInfo planInfo, DynamicObject standardInfo) {
        this.packagePath = packagePath;
        this.planInfo = planInfo;
        this.standardInfo = standardInfo;
    }

    public abstract String getFileExtName();

    public abstract ExportPlanStandardInfo buildExportPlanInfos(Long var1);

    public abstract String generateFileOp(SingleTaskContext var1, FileSingleExportContext var2, Set<Long> var3) throws Exception;

    protected void write(IExportWrite iExportWrite, Object writer) throws Exception {
        StructureSingleExportContext context = iExportWrite.getContext();
        List<IExportExtHandle> handleList = GetExportExtHandleFactory.getExtPluginHandle(context.getSingleExportContext(), context.getEntityName());
        String selectPropertis = new GetSelectPropertisHandle(context).getSelectPropertis();
        for (IExportExtHandle iExportExtHandle : handleList) {
            selectPropertis = iExportExtHandle.getSelectPropertis(context, selectPropertis);
        }
        context.setSelectPropertis(selectPropertis);
        Set<QFilter> entryQFilters = new GenerateExportPlanQFilters(context.getSingleExportContext(), context.getCommonfilter()).getfilter(context.getEntityName());
        for (IExportExtHandle handle : handleList) {
            entryQFilters = handle.getFilters(context, entryQFilters);
        }
        String string = selectPropertis;
        Set<QFilter> filters = entryQFilters;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)UUID.randomUUID().toString().replace("-", ""), (String)context.getEntityName(), (String)string, (QFilter[])filters.toArray(new QFilter[0]), null);
        for (IExportExtHandle handle : handleList) {
            dataSet = handle.getDataSource(context, dataSet, entryQFilters);
        }
        if (dataSet != null) {
            iExportWrite.write(writer, dataSet, handleList);
        }
    }

    protected static String getFullPath(String exportPath, String filename) {
        return exportPath + File.separator + filename;
    }

    public IExportWrite getFileWrite(SingleTaskContext taskContext, FileSingleExportContext context, Long structId) {
        return GetFileWriteFactory.getExportPlanFileWrite(context, taskContext.getFileType().getName(), structId).get(0);
    }

    public List<IExportExtHandle> getWriteHandleList(IExportWrite IExportWrite2) {
        StructureSingleExportContext context = IExportWrite2.getContext();
        List<IExportExtHandle> handleList = GetExportExtHandleFactory.getExtPluginHandle(context.getSingleExportContext(), context.getEntityName());
        return handleList;
    }

    public CachedDataSet getCachedDataSet(IExportWrite iExportWrite, List<IExportExtHandle> handleList) {
        StructureSingleExportContext context = iExportWrite.getContext();
        String selectPropertis = new GetSelectPropertisHandle(context).getSelectPropertis();
        for (IExportExtHandle iExportExtHandle : handleList) {
            selectPropertis = iExportExtHandle.getSelectPropertis(context, selectPropertis);
        }
        context.setSelectPropertis(selectPropertis);
        Set<QFilter> entryQFilters = new GenerateExportPlanQFilters(context.getSingleExportContext(), context.getCommonfilter()).getfilter(context.getEntityName());
        for (IExportExtHandle handle : handleList) {
            entryQFilters = handle.getFilters(context, entryQFilters);
        }
        String string = selectPropertis;
        Set<QFilter> filters = entryQFilters;
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)UUID.randomUUID().toString().replace("-", ""), (String)context.getEntityName(), (String)string, (QFilter[])filters.toArray(new QFilter[0]), null);
        for (IExportExtHandle handle : handleList) {
            dataSet = handle.getDataSource(context, dataSet, filters);
        }
        CacheHint cacheHint = CacheHint.getDefault();
        cacheHint.setTimeout(3600000L);
        CachedDataSet cachedDataSet = dataSet.cache(cacheHint);
        return cachedDataSet;
    }

    public abstract String writeFile(SingleTaskContext var1, String var2, IExportWrite var3, DataSet var4, List<IExportExtHandle> var5) throws Exception;
}

