/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.processor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.fea.enums.XmlEncodingEnum;
import kd.fi.fea.model.ExportPlanStandardInfo;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.factory.GetFileWriteFactory;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.writer.CSVWrite;
import kd.fi.fea.opservice.export.writer.IExportWrite;
import kd.fi.fea.util.FileUtil;

public class CSVExportProcessor
extends AbstractExportProcessor {
    private Log logger = LogFactory.getLog(CSVExportProcessor.class);

    public CSVExportProcessor(String packagePath, PlanInfo planInfo, DynamicObject standardInfo) {
        super(packagePath, planInfo, standardInfo);
    }

    @Override
    public String getFileExtName() {
        return ".csv";
    }

    @Override
    public ExportPlanStandardInfo buildExportPlanInfos(Long standardEntry) {
        return null;
    }

    @Override
    public String generateFileOp(SingleTaskContext taskContext, FileSingleExportContext context, Set<Long> structIds) throws Exception {
        return this.innerGenerateFileOp(taskContext, context, structIds);
    }

    @Override
    public IExportWrite getFileWrite(SingleTaskContext taskContext, FileSingleExportContext context, Long structId) {
        return GetFileWriteFactory.getExportPlanFileWrite(context, taskContext.getFileType().getName(), structId).get(0);
    }

    @Override
    public String writeFile(SingleTaskContext taskContext, String filePath, IExportWrite exportWrite, DataSet dataSet, List<IExportExtHandle> handleList) throws Exception {
        String encoding = "gbk";
        String standCfgEncoding = taskContext.getEncoding();
        if (StringUtils.isNotEmpty((String)standCfgEncoding)) {
            encoding = XmlEncodingEnum.getName((String)standCfgEncoding);
        }
        String wordSplit = this.standardInfo.getString("splitcode");
        String path = null;
        CSVWrite writer = null;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        try {
            File file = FileUtil.newFile((String)filePath);
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)out, encoding);
            writer = new CSVWrite(osw);
            if (wordSplit != null && wordSplit.length() > 0) {
                writer.setWordSplit(wordSplit);
            }
            exportWrite.write(writer, dataSet, handleList);
            path = file.getPath();
        }
        catch (Exception e) {
            this.logger.error("write file error", (Throwable)e);
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return path;
    }

    private String innerGenerateFileOp(SingleTaskContext taskContext, FileSingleExportContext context, Set<Long> structIds) throws Exception {
        String filePath = this.packagePath + File.separator + taskContext.getTaskId() + this.getFileExtName();
        String encoding = "gbk";
        String standCfgEncoding = taskContext.getEncoding();
        if (StringUtils.isNotEmpty((String)standCfgEncoding)) {
            encoding = XmlEncodingEnum.getName((String)standCfgEncoding);
        }
        String wordSplit = this.standardInfo.getString("splitcode");
        ArrayList<IExportWrite> writes = new ArrayList<IExportWrite>(20);
        for (Long structId : structIds) {
            writes.addAll(GetFileWriteFactory.getExportPlanFileWrite(context, taskContext.getFileType().getName(), structId));
        }
        String path = null;
        CSVWrite writer = null;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        try {
            File file = new File(filePath);
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)out, encoding);
            writer = new CSVWrite(osw);
            if (wordSplit != null && wordSplit.length() > 0) {
                writer.setWordSplit(wordSplit);
            }
            for (IExportWrite exportWrite : writes) {
                super.write(exportWrite, writer);
            }
            path = file.getPath();
        }
        catch (Exception e) {
            this.logger.error("write file error", (Throwable)e);
            throw e;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        return path;
    }
}

