/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fea.model.DataElement;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.DataStructureExportPlanModel;
import kd.fi.fea.model.DataType;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;

public class ExportPlanStructureProcessor {
    public static List<DataStructureExportPlanModel> loadStructure(FileSingleExportContext singleExportContext, Long structureid) {
        List<DataStructureExportPlanModel> list = singleExportContext.getStructures().get(structureid.toString());
        if (list == null) {
            list = new ArrayList<DataStructureExportPlanModel>(1);
        }
        return list;
    }

    public static Map<String, List<DataStructureExportPlanModel>> loadStructure(Set<Long> structIds) {
        String selectFields = ExportPlanStructureProcessor.getSelectFields();
        ArrayList<DataStructureEntryExportPlanModel> structureEntryList = new ArrayList<DataStructureEntryExportPlanModel>(1);
        HashMap<String, List<DataStructureExportPlanModel>> structureEntryMap = new HashMap<String, List<DataStructureExportPlanModel>>(30);
        DataStructureExportPlanModel structure = null;
        String tempId = "";
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"ExportPlanStructureProcessor.LoadStructure", (String)"fea_datastructure", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", structIds)}, (String)"id,treeentryentity.seq");){
            for (Row row : dSet) {
                String id = row.getString("id");
                if (!tempId.equals(id)) {
                    tempId = id;
                    structure = new DataStructureExportPlanModel();
                    structure.setEntity(row.getString("entity"));
                    structure.setCommonfilter(row.getString("commonfilter"));
                    structure.setName(row.getString("name"));
                    structure.setNumber(row.getString("number"));
                    structureEntryList = new ArrayList(30);
                    structure.setTreeentryentity(structureEntryList);
                    structureEntryMap.put(row.getString("id"), Collections.singletonList(structure));
                }
                DataStructureEntryExportPlanModel structureEntry = new DataStructureEntryExportPlanModel();
                structureEntry.setType(row.getString("type"));
                structureEntry.setSeq(row.getInteger("seq").intValue());
                structureEntry.setValue(row.getString("value"));
                structureEntry.setValuedesc(row.getString("valuedesc"));
                structureEntry.setStructName(row.getString("valuenumber"));
                DataElement element = new DataElement();
                structureEntry.setElement(element);
                element.setRefId(row.getLong("refid"));
                Boolean isAssistItem = row.getBoolean("assistitem");
                element.setAssistItem(isAssistItem.booleanValue());
                if (isAssistItem.booleanValue()) {
                    element.setAssistCount(row.getInteger("count").intValue());
                    element.setPrefixAssistName(row.getString("namefield1"));
                    element.setSuffixAssistName(row.getString("namefield2"));
                }
                DataType dataType = new DataType();
                element.setDataType(dataType);
                dataType.setType(row.getString("elementtype"));
                dataType.setFormatter(row.getString("formatter"));
                dataType.setLength(row.getInteger("length"));
                dataType.setTotallength(row.getInteger("totallength"));
                dataType.setDecimallength(row.getInteger("decimallength"));
                dataType.setIntegerlength(row.getInteger("integerlength"));
                structureEntryList.add(structureEntry);
            }
        }
        return structureEntryMap;
    }

    private static String getSelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>(32);
        selectFields.add("entity");
        selectFields.add("commonfilter");
        selectFields.add("name");
        selectFields.add("number");
        selectFields.add("id");
        selectFields.add("treeentryentity.type type");
        selectFields.add("treeentryentity.seq seq");
        selectFields.add("treeentryentity.value value");
        selectFields.add("treeentryentity.refid.name valuedesc");
        selectFields.add("treeentryentity.refid.number valuenumber");
        selectFields.add("treeentryentity.refid refid");
        selectFields.add("treeentryentity.refid.assistitem assistitem");
        selectFields.add("treeentryentity.refid.count count");
        selectFields.add("treeentryentity.refid.namefield1 namefield1");
        selectFields.add("treeentryentity.refid.namefield2 namefield2");
        selectFields.add("treeentryentity.refid.type.type elementtype");
        selectFields.add("treeentryentity.refid.type.formatter formatter");
        selectFields.add("treeentryentity.refid.type.length length");
        selectFields.add("treeentryentity.refid.type.totallength totallength");
        selectFields.add("treeentryentity.refid.type.decimallength decimallength");
        selectFields.add("treeentryentity.refid.type.integerlength integerlength");
        return String.join((CharSequence)",", selectFields);
    }
}

