/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.processor;

import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.processor.CSVExportProcessor;
import kd.fi.fea.opservice.export.processor.XmlExportProcessor;

public abstract class ExportProcessorFactory {
    protected String packagePath;
    protected DynamicObject standardInfo;

    public static AbstractExportProcessor getProcessor(String packagePath, PlanInfo planInfo) {
        Long groupId = planInfo.getGroup();
        DynamicObject standardInfo = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"fea_standard");
        DynamicObjectCollection standardentry = standardInfo.getDynamicObjectCollection("standardentry");
        Iterator it = standardentry.iterator();
        while (it.hasNext()) {
            DynamicObject standardentryRow = (DynamicObject)it.next();
            boolean disable = standardentryRow.getBoolean("disable");
            if (!disable) continue;
            it.remove();
        }
        String fileTypeValue = standardInfo.getString("filetype");
        String fileType = FileTypeEnum.getName((String)fileTypeValue);
        AbstractExportProcessor processor = null;
        switch (fileType) {
            case "xml": {
                processor = new XmlExportProcessor(packagePath, planInfo, standardInfo);
                break;
            }
            case "csv": {
                processor = new CSVExportProcessor(packagePath, planInfo, standardInfo);
                break;
            }
            default: {
                processor = null;
            }
        }
        return processor;
    }

    protected ExportProcessorFactory(String packagePath, PlanInfo planInfo) {
        this.packagePath = packagePath;
        this.loadStandard(planInfo);
    }

    private void loadStandard(PlanInfo planInfo) {
        Long groupId = planInfo.getGroup();
        this.standardInfo = BusinessDataServiceHelper.loadSingleFromCache((Object)groupId, (String)"fea_standard");
        String fileType = this.standardInfo.getString("filetype");
    }
}

