/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.processor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.SecurityUtils;
import kd.fi.fea.enums.XmlEncodingEnum;
import kd.fi.fea.model.ExportPlanStandardInfo;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.factory.GetFileWriteFactory;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.writer.FeaXMLWriter;
import kd.fi.fea.opservice.export.writer.IExportWrite;
import kd.fi.fea.util.FileUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;

public class XmlExportProcessor
extends AbstractExportProcessor {
    private static final Log logger = LogFactory.getLog(XmlExportProcessor.class);

    public XmlExportProcessor(String packagePath, PlanInfo planInfo, DynamicObject standardInfo) {
        super(packagePath, planInfo, standardInfo);
    }

    @Override
    public String getFileExtName() {
        return ".xml";
    }

    @Override
    public ExportPlanStandardInfo buildExportPlanInfos(Long standardEntry) {
        DynamicObjectCollection standardentry = this.standardInfo.getDynamicObjectCollection("standardentry");
        for (DynamicObject standardentryRow : standardentry) {
            DynamicObjectCollection subEntry;
            if (!standardentryRow.getPkValue().equals(standardEntry) || (subEntry = standardentryRow.getDynamicObjectCollection("standardsubentry")).isEmpty()) continue;
            ExportPlanStandardInfo exportPlanStandardInfo = new ExportPlanStandardInfo();
            exportPlanStandardInfo.setRootName(standardentryRow.getString("filename"));
            LinkedHashMap<String, String> rootAtt = new LinkedHashMap<String, String>();
            for (DynamicObject dyn : subEntry) {
                String prop = dyn.getString("prop");
                String value = dyn.getString("value");
                rootAtt.put(prop, value);
            }
            exportPlanStandardInfo.setRootAtt(rootAtt);
            return exportPlanStandardInfo;
        }
        return null;
    }

    @Override
    public String generateFileOp(SingleTaskContext taskContext, FileSingleExportContext context, Set<Long> structIds) throws Exception {
        return this.innerGenerateFileOp(taskContext, context, structIds);
    }

    private String innerGenerateFileOp(SingleTaskContext taskContext, FileSingleExportContext context, Set<Long> structIds) throws Exception {
        ExportPlanStandardInfo exportPlanStandardInfo = context.getExportPlanStandardInfo();
        String filePath = this.packagePath + File.separator + taskContext.getTaskId() + ".xml";
        String encoding = XmlEncodingEnum.getName((String)taskContext.getEncoding());
        String rootName = exportPlanStandardInfo.getRootName();
        Map rootAtt = exportPlanStandardInfo.getRootAtt();
        ArrayList<IExportWrite> writes = new ArrayList<IExportWrite>(20);
        for (Long structId : structIds) {
            writes.addAll(GetFileWriteFactory.getExportPlanFileWrite(context, taskContext.getFileType().getName(), structId));
        }
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        for (Map.Entry entry : rootAtt.entrySet()) {
            String entryKey = (String)entry.getKey();
            if ("xmlns".equals(entryKey)) {
                root.addAttribute(new QName(entryKey, new Namespace("", (String)entry.getValue())), (String)entry.getValue());
                continue;
            }
            root.addAttribute(entryKey, (String)entry.getValue());
        }
        String path = null;
        FeaXMLWriter writer = null;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        try {
            File file = new File(SecurityUtils.normalize((String)filePath));
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)out, encoding);
            OutputFormat compactPrint = OutputFormat.createPrettyPrint();
            compactPrint.setEncoding(encoding);
            writer = new FeaXMLWriter(osw, compactPrint);
            writer.startDocument();
            writer.writeOpen(root);
            for (IExportWrite exportWrite : writes) {
                super.write(exportWrite, writer);
            }
            writer.println();
            writer.write("\t");
            writer.writeClose(root);
            writer.endDocument();
            writer.flush();
            path = file.getPath();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return path;
    }

    @Override
    public String writeFile(SingleTaskContext taskContext, String filePath, IExportWrite iExportWrite, DataSet dataSet, List<IExportExtHandle> handleList) throws Exception {
        StructureSingleExportContext context = iExportWrite.getContext();
        ExportPlanStandardInfo exportPlanStandardInfo = context.getSingleExportContext().getExportPlanStandardInfo();
        String encoding = XmlEncodingEnum.getName((String)taskContext.getEncoding());
        String rootName = exportPlanStandardInfo.getRootName();
        Map rootAtt = exportPlanStandardInfo.getRootAtt();
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement(rootName);
        for (Map.Entry entry : rootAtt.entrySet()) {
            String entryKey = (String)entry.getKey();
            if ("xmlns".equals(entryKey)) {
                root.addAttribute(new QName(entryKey, new Namespace("", (String)entry.getValue())), (String)entry.getValue());
                continue;
            }
            root.addAttribute(entryKey, (String)entry.getValue());
        }
        for (IExportExtHandle handle : handleList) {
            handle.getSelectPropertis(context, "");
        }
        String path = null;
        FeaXMLWriter writer = null;
        FileOutputStream out = null;
        OutputStreamWriter osw = null;
        try {
            File file = FileUtil.newFile((String)filePath);
            out = new FileOutputStream(file);
            osw = new OutputStreamWriter((OutputStream)out, encoding);
            OutputFormat compactPrint = OutputFormat.createPrettyPrint();
            compactPrint.setEncoding(encoding);
            writer = new FeaXMLWriter(osw, compactPrint);
            writer.startDocument();
            writer.writeOpen(root);
            iExportWrite.write(writer, dataSet, handleList);
            writer.println();
            writer.write("\t");
            writer.writeClose(root);
            writer.endDocument();
            writer.flush();
            path = file.getPath();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
        return path;
    }
}

