/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fea.accsys.AccSysUtil;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.model.DataStructureExportPlanModel;
import kd.fi.fea.model.ExprotPlanInfo;
import kd.fi.fea.opservice.export.builder.context.ExportContext;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.task.SingleTaskContext;

public abstract class AbstractExportTask {
    protected SingleTaskContext taskContext;
    protected Long standardEntry;

    public SingleTaskContext getTaskContext() {
        return this.taskContext;
    }

    protected Map<Long, Long> getAcctBookMap() {
        QFilter[] qFilterList = new QFilter[]{new QFilter("org", "=", (Object)this.taskContext.getOrgId()), new QFilter("bookstype", "=", (Object)this.taskContext.getBookType())};
        Map accountBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"id, org.id", (QFilter[])qFilterList);
        HashMap<Long, Long> acctBookMap = new HashMap<Long, Long>(accountBooks.size());
        for (DynamicObject acctBook : accountBooks.values()) {
            acctBookMap.put(acctBook.getLong("org.id"), acctBook.getLong("id"));
        }
        return acctBookMap;
    }

    protected FileSingleExportContext createExportContext(AbstractExportProcessor exportProcessor, Map<String, List<IExportExtHandle>> handles, Map<String, List<DataStructureExportPlanModel>> structureModelMap, Map<Long, Long> acctBookMap, Map<Long, Set<Long>> bizOrgIds) {
        FileSingleExportContext singleExportContext = new FileSingleExportContext();
        singleExportContext.setOrgId(this.taskContext.getOrgId());
        singleExportContext.setHandles(handles);
        singleExportContext.setStructures(structureModelMap);
        ExprotPlanInfo exprotPlanInfo = new ExprotPlanInfo();
        exprotPlanInfo.setBookTypeId(this.taskContext.getBookType());
        exprotPlanInfo.setPeriodtypeId(this.taskContext.getPeriodType());
        exprotPlanInfo.setPlanId(this.taskContext.getPlanId());
        exprotPlanInfo.setBeginperiodId(this.taskContext.getBeginPeriodId());
        exprotPlanInfo.setEndperiodId(this.taskContext.getEndPeriodId());
        exprotPlanInfo.setFiletype(this.taskContext.getFileType().getName());
        exprotPlanInfo.setComAssistFilter(this.taskContext.getConAssistFilter());
        ExportContext exportContext = new ExportContext(exprotPlanInfo);
        singleExportContext.setExportContext(exportContext);
        singleExportContext.setExportPlanStandardInfo(exportProcessor.buildExportPlanInfos(this.standardEntry));
        singleExportContext.setAcctBookId(acctBookMap.get(this.taskContext.getOrgId()));
        singleExportContext.setBizOrgIds(bizOrgIds.get(this.taskContext.getOrgId()));
        AccountBookInfo acctBookInfo = AccSysUtil.getBookFromAccSys((long)this.taskContext.getOrgId(), (long)this.taskContext.getBookType(), (long)this.taskContext.getBeginPeriodId());
        if (acctBookInfo == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7:%1$s\uff0c\u4e0d\u5b58\u5728\u5bf9\u5e94\u8d26\u7c3f\u7c7b\u578b\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"AbstractExportTask_1", (String)"fi-fea-business", (Object[])new Object[0]), this.taskContext.getOrgName()));
        }
        singleExportContext.setAcctBookInfo(acctBookInfo);
        return singleExportContext;
    }
}

