/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.opservice.export.task.ExportTaskStatusUpdateHelper;
import kd.fi.fea.opservice.export.task.FileExportTask;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.utils.FaBillParamUtils;
import kd.fi.fea.util.ThrowableHelper;
import org.apache.commons.collections4.MapUtils;

public class ExportTaskConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(ExportTaskConsumer.class);
    private static ThreadPool fixedThreadPool = ThreadPools.newFixedThreadPool((String)"export-task-pool", (int)10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker msgAck) {
        DynamicObject exportTask = null;
        Long subtask = null;
        try {
            Map params = (Map)msgBody;
            Long exportId = MapUtils.getLong((Map)params, (Object)"exportId");
            boolean retry = MapUtils.getBoolean((Map)params, (Object)"retry", (Boolean)false);
            exportTask = BusinessDataServiceHelper.loadSingle((Object)exportId, (String)"fea_export_task");
            if (exportTask == null) {
                logger.warn("file export task [{}] is not exists!", (Object)exportId);
                msgAck.ack(msgId);
                return;
            }
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PROFEA");
            if (!result.getHasLicense().booleanValue()) {
                logger.warn("\u7f3a\u5c11\u8bb8\u53ef\uff0c\u65e0\u6cd5\u6267\u884c\u5bfc\u51fa\u4efb\u52a1");
                throw new KDBizException(result.getMsg());
            }
            String taskStatus = exportTask.getString("taskstatus");
            if (!retry) {
                if ("D".equals(taskStatus)) {
                    logger.warn("file export task [{}] has execute error, pass!", (Object)exportId);
                    msgAck.ack(msgId);
                    return;
                }
                if ("C".equals(taskStatus)) {
                    msgAck.ack(msgId);
                    return;
                }
                if ("E".equals(taskStatus)) {
                    logger.warn("file export task [{}] has cancel, pass!", (Object)exportId);
                    msgAck.ack(msgId);
                    return;
                }
            } else if ("B".equals(taskStatus)) {
                msgAck.discard(msgId);
                return;
            }
            Long bookType = MapUtils.getLong((Map)params, (Object)"bookType");
            Long periodType = MapUtils.getLong((Map)params, (Object)"periodType");
            String encoding = MapUtils.getString((Map)params, (Object)"encoding");
            String fileType = MapUtils.getString((Map)params, (Object)"fileType");
            subtask = MapUtils.getLong((Map)params, (Object)"subTask");
            Long planId = MapUtils.getLong((Map)params, (Object)"planId");
            Long beginPeriod = MapUtils.getLong((Map)params, (Object)"beginPeriod");
            Long endPeriod = MapUtils.getLong((Map)params, (Object)"endPeriod");
            DynamicObject subTaskObject = QueryServiceHelper.queryOne((String)"fea_export_task", (String)"taskentry.org org,taskentry.org.name orgname, taskentry.standardentry standardentry, taskentry.struct struct, taskentry.zipname zipname", (QFilter[])new QFilter[]{new QFilter("taskentry", "=", (Object)subtask)});
            SingleTaskContext context = new SingleTaskContext();
            context.setRetry(retry);
            context.setOrgId(subTaskObject.getLong("org"));
            context.setOrgName(subTaskObject.getString("orgname"));
            context.setPlanId(planId);
            context.setExportId(exportId);
            context.setTaskId(subtask);
            context.setBookType(bookType);
            context.setPeriodType(periodType);
            context.setFileType(FileTypeEnum.valueOf((String)fileType));
            context.setEncoding(encoding);
            context.setBeginPeriodId(beginPeriod);
            context.setEndPeriodId(endPeriod);
            context.setFileName(subTaskObject.getString("zipname"));
            String comassistfilter = exportTask.getString("comassistfilter_tag");
            if (StringUtils.isNotEmpty((String)comassistfilter)) {
                String[] split = comassistfilter.split(",");
                HashSet<Long> filterIdSet = new HashSet<Long>(10);
                for (String id : split) {
                    filterIdSet.add(Long.valueOf(id));
                }
                context.setConAssistFilter(filterIdSet);
            }
            long standardentry = subTaskObject.getLong("standardentry");
            long structId = subTaskObject.getLong("struct");
            FileExportTask fileExportTask = new FileExportTask(context, standardentry, structId);
            boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
            Future future = enablePlatformThreadPool ? ThreadService.submit((Callable)fileExportTask, (TaskType)TaskType.FEA_EXPORT_TASK, (RequestContext)RequestContext.get()) : fixedThreadPool.submit((Callable)fileExportTask, RequestContext.get());
            if ("success".equals(future.get())) {
                msgAck.ack(msgId);
            }
        }
        catch (Throwable e) {
            logger.error("handle task message error", e);
            if (exportTask != null) {
                ExportTaskStatusUpdateHelper.updateTaskFail(exportTask.getLong("id"), subtask, ThrowableHelper.toString((Throwable)e));
            }
        }
        finally {
            msgAck.ack(msgId);
        }
    }
}

