/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.fea.opservice.export.task.ExportTaskConsumer;
import kd.fi.fea.opservice.export.task.ExportTaskStatusUpdateHelper;
import kd.fi.fea.opservice.export.task.FileExportSplitTask;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.utils.FaBillParamUtils;
import org.apache.commons.collections4.MapUtils;

public class ExportTaskDetailConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(ExportTaskConsumer.class);
    private static ThreadPool fixedThreadPool = ThreadPools.newFixedThreadPool((String)"export-task-detail-pool", (int)10);

    public void onMessage(Object msgBody, String msgId, boolean resend, MessageAcker msgAck) {
        DynamicObject subTask = null;
        FileExportSplitTask splitTask = null;
        SingleTaskContext taskContext = null;
        DynamicObject exportTask = null;
        try {
            logger.info("\u63a5\u6536\u5bfc\u51fa\u5b50\u4efb\u52a1\uff0c\u53c2\u6570={}", msgBody);
            Map pubBody = (Map)msgBody;
            Map taskParam = (Map)pubBody.get("taskParam");
            subTask = (DynamicObject)taskParam.get("subTask");
            taskContext = (SingleTaskContext)taskParam.get("taskContext");
            Long standardEntry = MapUtils.getLong((Map)taskParam, (Object)"standardEntry");
            String cacheId = MapUtils.getString((Map)taskParam, (Object)"cacheId");
            String prefixName = MapUtils.getString((Map)taskParam, (Object)"prefixName");
            Integer index = MapUtils.getInteger((Map)taskParam, (Object)"index");
            splitTask = -1 != index ? new FileExportSplitTask(subTask, taskContext, standardEntry, cacheId, prefixName, index) : new FileExportSplitTask(subTask, taskContext, standardEntry, cacheId, prefixName);
            exportTask = BusinessDataServiceHelper.loadSingle((Object)taskContext.getExportId(), (String)"fea_export_task");
        }
        catch (Throwable e) {
            logger.error("split task exec fail", e);
            if (splitTask != null) {
                ExportTaskStatusUpdateHelper.updateSubTaskFail(subTask.getPkValue(), ResManager.loadKDString((String)"\u6d88\u606f\u683c\u5f0f\u4e0d\u6b63\u786e:%s", (String)"ExportTaskDetailConsumer_1", (String)"fi-fea-business", (Object[])new Object[]{e.getMessage()}));
            }
            msgAck.ack(msgId);
            return;
        }
        try {
            if (exportTask == null) {
                logger.warn("file export task [{}] is not exists!", (Object)taskContext.getExportId());
                msgAck.ack(msgId);
                return;
            }
            String taskStatus = exportTask.getString("taskstatus");
            if ("D".equals(taskStatus)) {
                logger.warn("file export task [{}] has execute error, pass!", (Object)taskContext.getExportId());
                msgAck.ack(msgId);
                return;
            }
            if ("C".equals(taskStatus)) {
                msgAck.ack(msgId);
                return;
            }
            if ("E".equals(taskStatus)) {
                logger.warn("file export task [{}] has cancel, pass!", (Object)taskContext.getExportId());
                msgAck.ack(msgId);
                return;
            }
            boolean enablePlatformThreadPool = FaBillParamUtils.getBooleanValue(null, null, null, "enableplatformthreadpool");
            Future future = enablePlatformThreadPool ? ThreadService.submit((Callable)splitTask, (TaskType)TaskType.FEA_EXPORT_TASK_DETAIL, (RequestContext)RequestContext.get()) : fixedThreadPool.submit((Callable)splitTask);
            String result = (String)future.get();
            if ("success".equals(result)) {
                msgAck.ack(msgId);
            }
        }
        catch (Throwable e) {
            logger.error("split task exec fail", e);
            ExportTaskStatusUpdateHelper.updateSubTaskFail(subTask.getPkValue(), String.format(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u6784\u5efa\u5931\u8d25:%s", (String)"ExportTaskDetailConsumer_2", (String)"fi-fea-business", (Object[])new Object[0]), e.getMessage()));
        }
    }
}

