/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.SessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ExportTaskStatusUpdateHelper {
    private static Log logger = LogFactory.getLog(ExportTaskStatusUpdateHelper.class);
    private static DBRoute dbRoute = DBRoute.of((String)"fi");
    private static SessionlessCache<String> appCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fea");

    public static void startTask(Long exportId, Long taskId, Date taskStartTime) {
        String instanceId = Instance.getInstanceId();
        try (TXHandle h = TX.required();){
            try {
                DB.update((DBRoute)dbRoute, (String)"update t_fea_exporttaskentry set fsubtaskstatus = ?, ftaskstarttime = ?, fsrvinstance = ? where fentryid = ?", (Object[])new Object[]{"B", taskStartTime, instanceId, taskId});
                DB.update((DBRoute)dbRoute, (String)"update t_fea_exporttask set ftaskstatus = ? where fid = ?", (Object[])new Object[]{"B", exportId});
                HashMap<String, Object> cache = new HashMap<String, Object>();
                cache.put("status", "B");
                cache.put("percent", 0);
                appCache.put("export/task/" + exportId, (Object)SerializationUtils.serializeToBase64(cache), 21600);
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void startTaskDetail(Object subTaskId) {
        DB.execute((DBRoute)dbRoute, (String)"update t_fea_tasksubentry set ftaskdetailstatus = 'B' where fdetailid = ?", (Object[])new Object[]{subTaskId});
    }

    public static void updateTaskTotalStatus(Long exportId, Date taskEndTime) {
        DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)exportId, (String)"fea_export_task");
        DynamicObjectCollection taskentry = exportTask.getDynamicObjectCollection("taskentry");
        int finishTask = 0;
        int errorTask = 0;
        for (DynamicObject task : taskentry) {
            String subtaskstatus = task.getString("subtaskstatus");
            if ("C".equalsIgnoreCase(subtaskstatus)) {
                ++finishTask;
                continue;
            }
            if (!"D".equalsIgnoreCase(subtaskstatus)) continue;
            ++errorTask;
        }
        exportTask.set("totalprocess", (Object)((double)finishTask * 1.0 / (double)taskentry.size() * 100.0));
        if (errorTask > 0) {
            exportTask.set("taskstatus", (Object)"D");
        } else if (finishTask == taskentry.size()) {
            exportTask.set("taskstatus", (Object)"C");
            exportTask.set("endtime", (Object)taskEndTime);
        }
        HashMap<String, Object> cache = new HashMap<String, Object>();
        cache.put("status", exportTask.getString("taskstatus"));
        cache.put("percent", exportTask.getInt("totalprocess"));
        SaveServiceHelper.update((DynamicObject)exportTask);
        appCache.put("export/task/" + exportId, (Object)SerializationUtils.serializeToBase64(cache), 21600);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSubTaskStatus(Long exportId, Long taskId, Date subTaskEndTime) {
        DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)exportId, (String)"fea_export_task");
        String taskStatus = exportTask.getString("taskstatus");
        if ("C".equals(taskStatus) || "D".equals(taskStatus) || "E".equals(taskStatus)) {
            return;
        }
        DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
        DynamicObject taskDetailEntry = taskEntry.stream().filter(obj -> taskId.equals(obj.getPkValue())).findFirst().get();
        DynamicObjectCollection subTaskEntry = taskDetailEntry.getDynamicObjectCollection("subtaskentry");
        int finishTask = 0;
        int errorTask = 0;
        ArrayList<String> urls = new ArrayList<String>();
        for (DynamicObject task : subTaskEntry) {
            String subtaskstatus = task.getString("taskdetailstatus");
            if ("C".equalsIgnoreCase(subtaskstatus)) {
                String url = task.getString("tmpfileurl");
                ++finishTask;
                urls.add(url);
                continue;
            }
            if (!"D".equals(subtaskstatus)) continue;
            ++errorTask;
        }
        boolean subTaskFinish = false;
        taskDetailEntry.set("subprocess", (Object)((double)finishTask * 1.0 / (double)subTaskEntry.size() * 100.0));
        if (errorTask > 0) {
            taskDetailEntry.set("subtaskstatus", (Object)"D");
            exportTask.set("taskstatus", (Object)"D");
            subTaskFinish = true;
        } else if (finishTask == subTaskEntry.size()) {
            subTaskFinish = true;
            taskDetailEntry.set("subtaskstatus", (Object)"C");
            taskDetailEntry.set("taskendtime", (Object)subTaskEndTime);
            taskDetailEntry.set("fileexpiretime", (Object)KDDateUtils.addSeconds((Date)subTaskEndTime, (int)21600));
            String zipName = taskDetailEntry.getString("zipname");
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String zipFileUrl = fileCache.compress(zipName + ".zip", urls.toArray(new String[0]), 21600);
            int zipFileSize = 0;
            try (InputStream inputStream = fileCache.getInputStream(zipFileUrl);){
                zipFileSize = inputStream.available();
            }
            catch (IOException e) {
                logger.error("get fileSize error", (Throwable)e);
            }
            taskDetailEntry.set("zipfileurl", (Object)zipFileUrl);
            taskDetailEntry.set("zipfilesize", (Object)zipFileSize);
        }
        SaveServiceHelper.update((DynamicObject)exportTask);
        if (!subTaskFinish) {
            return;
        }
        DLock exportLock = DLock.create((String)("fi.fea.task." + exportId));
        try {
            boolean getLock = exportLock.tryLock(30000L);
            if (getLock) {
                ExportTaskStatusUpdateHelper.updateTaskTotalStatus(exportId, subTaskEndTime);
            }
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u9501\u83b7\u53d6\u5931\u8d25", (Throwable)e);
        }
        finally {
            exportLock.unlock();
        }
    }

    public static void updateTaskFail(Long exportId, Object task, String errorMessage) {
        ExportTaskStatusUpdateHelper.updateTaskFail(exportId, task, errorMessage, errorMessage);
    }

    public static void updateTaskFail(Long exportId, Object task, String errorMessage, String errMsgTag) {
        if (errorMessage.length() > 100) {
            errorMessage = errorMessage.substring(0, 100);
        }
        DB.update((DBRoute)dbRoute, (String)"update t_fea_exporttaskentry set fsubtaskstatus = ?, ferrorinfo=?, ferrorinfo_tag=? where fentryid = ?", (Object[])new Object[]{"D", errorMessage, errMsgTag, task});
        DB.update((DBRoute)dbRoute, (String)"update t_fea_exporttask set ftaskstatus = ? where fid = ?", (Object[])new Object[]{"D", exportId});
    }

    public static void updateSubTaskFail(Object subTask, String errorMessage) {
        ExportTaskStatusUpdateHelper.updateSubTaskFail(subTask, errorMessage, errorMessage);
    }

    public static void updateSubTaskFail(Object subTask, String errorMessage, String errorMsgTag) {
        if (errorMessage.length() > 100) {
            errorMessage = errorMessage.substring(0, 100);
        }
        DB.execute((DBRoute)dbRoute, (String)"update t_fea_tasksubentry set ftaskdetailstatus = 'D', ferrortext=?, ferrortext_tag=? where fdetailid = ?", (Object[])new Object[]{errorMessage, errorMsgTag, subTask});
    }

    public static void deleteTaskDetail(Long taskId) {
        DB.execute((DBRoute)dbRoute, (String)"delete from t_fea_tasksubentry where fentryid = ?", (Object[])new Object[]{taskId});
    }
}

