/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.fi.fea.model.DataStructureExportPlanModel;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.selectprop.GetSelectPropertisHandle;
import kd.fi.fea.opservice.export.factory.GetExportExtHandleFactory;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.processor.ExportPlanStructureProcessor;
import kd.fi.fea.opservice.export.processor.ExportProcessorFactory;
import kd.fi.fea.opservice.export.processor.ExprotPlanProcessor;
import kd.fi.fea.opservice.export.task.AbstractExportTask;
import kd.fi.fea.opservice.export.task.ExportTaskStatusUpdateHelper;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.task.TaskFileUtil;
import kd.fi.fea.opservice.export.writer.IExportWrite;
import kd.fi.fea.util.FeaUtil;
import kd.fi.fea.util.FileUtil;
import kd.fi.fea.util.ThrowableHelper;

public class FileExportSplitTask
extends AbstractExportTask
implements Callable<String> {
    private static Log logger = LogFactory.getLog(FileExportSplitTask.class);
    private DynamicObject subTask;
    private Integer index;
    private String cachedId;
    private Integer beginIndex;
    private Integer limit;
    private String parentPath = FileUtil.getUserTempPath();
    private String prefixName;
    private boolean hasIndex = false;
    private Date subTaskEndTime;

    public FileExportSplitTask(DynamicObject subTask, SingleTaskContext taskContext, Long standardEntry, String cachedId, String prefixName, Integer index) {
        this.standardEntry = standardEntry;
        this.taskContext = taskContext;
        this.subTask = subTask;
        this.index = index;
        this.cachedId = cachedId;
        this.beginIndex = subTask.getInt("beginindex");
        int endIndex = subTask.getInt("endindex");
        this.limit = endIndex - this.beginIndex;
        this.prefixName = prefixName;
        this.hasIndex = true;
    }

    public FileExportSplitTask(DynamicObject subTask, SingleTaskContext taskContext, Long standardEntry, String cacheId, String prefixName) {
        this.taskContext = taskContext;
        this.standardEntry = standardEntry;
        this.subTask = subTask;
        this.cachedId = cacheId;
        this.prefixName = prefixName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String call() {
        Date subTaskBeginTime = KDDateUtils.now();
        try {
            logger.info("subtask[{}]\u5f00\u59cb\u6267\u884c", this.subTask.getPkValue());
            ExportTaskStatusUpdateHelper.startTaskDetail(this.subTask.getPkValue());
            PlanInfo planInfo = ExprotPlanProcessor.loadExprotPlan(this.taskContext.getPlanId());
            AbstractExportProcessor exportProcessor = ExportProcessorFactory.getProcessor(this.parentPath, planInfo);
            Long structId = this.subTask.getLong("detailstruct");
            Map<String, Map<String, String>> handleConfig = GetExportExtHandleFactory.getExtPluginHandleConfig(this.taskContext.getFileType().getName());
            Map<String, List<IExportExtHandle>> handles = GetExportExtHandleFactory.getExtPluginHandle(handleConfig);
            Map<String, List<DataStructureExportPlanModel>> structureModelMap = ExportPlanStructureProcessor.loadStructure(Collections.singleton(structId));
            Map<Long, Long> acctBookMap = this.getAcctBookMap();
            HashSet<Long> bizOrgs = new HashSet<Long>();
            bizOrgs.add(this.taskContext.getOrgId());
            Map bizOrgIds = FeaUtil.getBizOrgIds(bizOrgs, (long)this.taskContext.getBookType());
            FileSingleExportContext singleExportContext = this.createExportContext(exportProcessor, handles, structureModelMap, acctBookMap, bizOrgIds);
            IExportWrite exportWrite = exportProcessor.getFileWrite(this.taskContext, singleExportContext, structId);
            List<IExportExtHandle> handleList = exportProcessor.getWriteHandleList(exportWrite);
            StructureSingleExportContext context = exportWrite.getContext();
            String selectPropertis = new GetSelectPropertisHandle(context).getSelectPropertis();
            for (IExportExtHandle handle : handleList) {
                selectPropertis = handle.getSelectPropertis(context, selectPropertis);
            }
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)this.cachedId);
            DataSet dataSet = cacheDataSet.toDataSet(Algo.create((String)("fi.fea.detailtask." + this.subTask.getPkValue())), false);
            String filePath = "";
            String uploadNae = "";
            if (this.hasIndex) {
                dataSet = dataSet.limit(this.beginIndex.intValue(), this.limit.intValue());
                filePath = this.parentPath + File.separator + this.prefixName + this.index + exportProcessor.getFileExtName();
                uploadNae = this.taskContext.getFileName() + "_" + this.index + exportProcessor.getFileExtName();
            } else {
                filePath = this.parentPath + File.separator + this.prefixName + "1" + exportProcessor.getFileExtName();
                uploadNae = this.taskContext.getFileName() + exportProcessor.getFileExtName();
            }
            exportProcessor.writeFile(this.taskContext, filePath, exportWrite, dataSet, handleList);
            String fileUrl = TaskFileUtil.uploadFile(filePath, uploadNae, 21600);
            File file = FileUtil.newFile((String)filePath);
            long fileSize = file.length();
            FileUtil.deleteKd((File)file);
            this.subTaskEndTime = KDDateUtils.now();
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"update t_fea_tasksubentry set ftaskdetailstatus = 'C', ferrortext=?, ftmpfileurl=?,ffilesize=? where fdetailid = ?", (Object[])new Object[]{this.cachedId, fileUrl, fileSize, this.subTask.getPkValue()});
            logger.info("subtask[{}]\u6267\u884c\u5b8c\u6210...", this.subTask.getPkValue());
        }
        catch (Throwable e) {
            logger.error("subtask[{}]\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a{}", this.subTask.getPkValue(), (Object)e);
            String errorTag = ThrowableHelper.toString((Throwable)e);
            String error = errorTag.length() > 255 ? errorTag.substring(0, 200) : errorTag;
            DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)"update t_fea_tasksubentry set ftaskdetailstatus = 'D', ferrortext=?, ferrortext_tag=? where fdetailid = ?", (Object[])new Object[]{error, errorTag, this.subTask.getPkValue()});
            String string = "fail";
            return string;
        }
        finally {
            DLock lock = DLock.create((String)("fi.fea.subtask." + this.taskContext.getTaskId()));
            try {
                boolean getLock = lock.tryLock(30000L);
                if (getLock) {
                    logger.info("[\u5206\u5e03\u5f0f\u9501]%\u83b7\u53d6\u5230\u72b6\u6001\u66f4\u65b0\u9501");
                    ExportTaskStatusUpdateHelper.updateSubTaskStatus(this.taskContext.getExportId(), this.taskContext.getTaskId(), this.subTaskEndTime);
                } else {
                    logger.error("[\u5206\u5e03\u5f0f\u9501]%\u83b7\u53d6\u5230\u72b6\u6001\u66f4\u65b0\u9501\u5931\u8d25");
                }
            }
            catch (Exception e) {
                logger.error("update lock error", (Throwable)e);
            }
            finally {
                lock.unlock();
                logger.info("[\u5206\u5e03\u5f0f\u9501]%\u91ca\u653e\u72b6\u6001\u66f4\u65b0\u9501");
            }
        }
        return "success";
    }
}

