/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.algo.CachedDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fea.model.DataStructureExportPlanModel;
import kd.fi.fea.model.PlanInfo;
import kd.fi.fea.opservice.export.builder.context.FileSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.factory.GetExportExtHandleFactory;
import kd.fi.fea.opservice.export.processor.AbstractExportProcessor;
import kd.fi.fea.opservice.export.processor.ExportPlanStructureProcessor;
import kd.fi.fea.opservice.export.processor.ExportProcessorFactory;
import kd.fi.fea.opservice.export.processor.ExprotPlanProcessor;
import kd.fi.fea.opservice.export.task.AbstractExportTask;
import kd.fi.fea.opservice.export.task.ExportTaskStatusUpdateHelper;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.opservice.export.task.TaskFileUtil;
import kd.fi.fea.opservice.export.writer.IExportWrite;
import kd.fi.fea.util.FeaUtil;
import kd.fi.fea.util.FileUtil;
import kd.fi.fea.util.ThrowableHelper;

public class FileExportTask
extends AbstractExportTask
implements Callable<String> {
    private static Log logger = LogFactory.getLog(FileExportTask.class);
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private final Long structId;
    private final Date taskStartTime;
    private Date taskEndTime;
    private final String taskFilePath;
    private final String taskFilePrefix;

    public FileExportTask(SingleTaskContext taskContext, Long standardEntry, Long structId) {
        this.taskContext = taskContext;
        this.standardEntry = standardEntry;
        this.structId = structId;
        this.taskStartTime = KDDateUtils.now();
        String userTempPath = FileUtil.getUserTempPath();
        String datePath = sdf.format(this.taskStartTime);
        this.taskFilePath = userTempPath;
        this.taskFilePrefix = datePath + "_" + taskContext.getTaskId() + "_";
        File parentPath = FileUtil.newFile((String)this.taskFilePath);
        if (!parentPath.exists()) {
            parentPath.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String call() {
        block28: {
            try {
                logger.info("task[{}]\u5f00\u59cb\u6267\u884c...", (Object)this.taskContext.getTaskId());
                ExportTaskStatusUpdateHelper.startTask(this.taskContext.getExportId(), this.taskContext.getTaskId(), this.taskStartTime);
                if (this.taskContext.isRetry()) {
                    ExportTaskStatusUpdateHelper.deleteTaskDetail(this.taskContext.getTaskId());
                }
                PlanInfo planInfo = ExprotPlanProcessor.loadExprotPlan(this.taskContext.getPlanId());
                AbstractExportProcessor exportProcessor = ExportProcessorFactory.getProcessor(this.taskFilePath, planInfo);
                HashSet<Long> structIds = (HashSet<Long>)planInfo.getStructureEntryMap().get(this.standardEntry);
                if (structIds == null) {
                    structIds = new HashSet<Long>(0);
                }
                if (this.structId != null && this.structId > 0L) {
                    structIds.clear();
                    structIds.add(this.structId);
                    this.handleSingleStruct(exportProcessor, structIds);
                    return "success";
                }
                this.filterStructs(structIds);
                DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)this.taskContext.getExportId(), (String)"fea_export_task");
                DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
                DynamicObject taskDetailEntry = taskEntry.stream().filter(obj -> this.taskContext.getTaskId().equals(obj.getPkValue())).findFirst().get();
                DynamicObjectCollection subTaskEntry = taskDetailEntry.getDynamicObjectCollection("subtaskentry");
                DynamicObject splitTaskObj = subTaskEntry.addNew();
                splitTaskObj.set("beginindex", (Object)0);
                splitTaskObj.set("endindex", (Object)0);
                splitTaskObj.set("taskdetailstatus", (Object)"B");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exportTask});
                Map<String, Map<String, String>> handleConfig = GetExportExtHandleFactory.getExtPluginHandleConfig(this.taskContext.getFileType().getName());
                Map<String, List<IExportExtHandle>> handles = GetExportExtHandleFactory.getExtPluginHandle(handleConfig);
                Map<String, List<DataStructureExportPlanModel>> structureModelMap = ExportPlanStructureProcessor.loadStructure(structIds);
                Map<Long, Long> acctBookMap = this.getAcctBookMap();
                HashSet<Long> bizOrgs = new HashSet<Long>();
                bizOrgs.add(this.taskContext.getOrgId());
                Map bizOrgIds = FeaUtil.getBizOrgIds(bizOrgs, (long)this.taskContext.getBookType());
                if (bizOrgIds == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"FileExportTask_1", (String)"fi-fea-business", (Object[])new Object[0]), this.taskContext.getOrgName(), this.taskContext.getBookType()));
                }
                FileSingleExportContext singleExportContext = this.createExportContext(exportProcessor, handles, structureModelMap, acctBookMap, bizOrgIds);
                String fileFullPath = exportProcessor.generateFileOp(this.taskContext, singleExportContext, structIds);
                File file = FileUtil.newFile((String)fileFullPath);
                long fileSize = file.length();
                String zipFilePath = TaskFileUtil.compressFile(this.taskContext, this.taskFilePath, this.taskFilePrefix, fileFullPath);
                FileUtil.deleteKd((File)file);
                File zipFile = FileUtil.newFile((String)zipFilePath);
                long zipFileSize = zipFile.length();
                String uploadFileName = this.taskContext.getOrgName() + "_" + this.taskContext.getFileName() + ".zip";
                String fileUrl = TaskFileUtil.uploadFile(zipFilePath, uploadFileName, 21600);
                FileUtil.deleteKd((File)zipFile);
                this.taskEndTime = KDDateUtils.now();
                logger.info("task[{}]\u6267\u884c\u5b8c\u6210...", (Object)this.taskContext.getTaskId());
                splitTaskObj.set("taskdetailstatus", (Object)"C");
                splitTaskObj.set("filesize", (Object)fileSize);
                taskDetailEntry.set("subtaskstatus", (Object)"C");
                taskDetailEntry.set("subprocess", (Object)100);
                taskDetailEntry.set("fileexpiretime", (Object)KDDateUtils.addSeconds((Date)this.taskEndTime, (int)21600));
                taskDetailEntry.set("taskendtime", (Object)this.taskEndTime);
                taskDetailEntry.set("zipfilesize", (Object)zipFileSize);
                taskDetailEntry.set("zipfileurl", (Object)fileUrl);
                DLock lock = DLock.create((String)("fi.fea.task." + this.taskContext.getExportId()));
                try {
                    boolean getLock = lock.tryLock(30000L);
                    if (getLock) {
                        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{exportTask});
                        ExportTaskStatusUpdateHelper.updateTaskTotalStatus(this.taskContext.getExportId(), this.taskEndTime);
                    }
                    break block28;
                }
                catch (Exception e) {
                    logger.error("update task total process error", (Throwable)e);
                    break block28;
                }
                finally {
                    lock.unlock();
                }
                catch (Exception e) {
                    try {
                        logger.error("task[{}]\u6267\u884c\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a", (Object)this.taskContext.getTaskId(), (Object)e);
                        splitTaskObj.set("taskdetailstatus", (Object)"D");
                        String errorTag = ThrowableHelper.toString((Exception)e);
                        splitTaskObj.set("errortext", (Object)(errorTag.length() > 200 ? errorTag.substring(0, 200) : errorTag));
                        splitTaskObj.set("errortext_tag", (Object)errorTag);
                        taskDetailEntry.set("subtaskstatus", (Object)"D");
                        exportTask.set("taskstatus", (Object)"D");
                    }
                    catch (Throwable throwable) {
                        DLock lock2 = DLock.create((String)("fi.fea.task." + this.taskContext.getExportId()));
                        try {
                            boolean getLock = lock2.tryLock(30000L);
                            if (getLock) {
                                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{exportTask});
                                ExportTaskStatusUpdateHelper.updateTaskTotalStatus(this.taskContext.getExportId(), this.taskEndTime);
                            }
                        }
                        catch (Exception e2) {
                            logger.error("update task total process error", (Throwable)e2);
                        }
                        finally {
                            lock2.unlock();
                        }
                        throw throwable;
                    }
                    lock = DLock.create((String)("fi.fea.task." + this.taskContext.getExportId()));
                    try {
                        boolean getLock = lock.tryLock(30000L);
                        if (getLock) {
                            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{exportTask});
                            ExportTaskStatusUpdateHelper.updateTaskTotalStatus(this.taskContext.getExportId(), this.taskEndTime);
                        }
                    }
                    catch (Exception e3) {
                        logger.error("update task total process error", (Throwable)e3);
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
            catch (Exception e) {
                logger.error("build task detail error", (Throwable)e);
                ExportTaskStatusUpdateHelper.updateTaskFail(this.taskContext.getExportId(), this.taskContext.getTaskId(), ResManager.loadKDString((String)"\u4efb\u52a1\u8be6\u60c5\u6784\u5efa\u5931\u8d25:%s", (String)"FileExportTask_2", (String)"fi-fea-business", (Object[])new Object[]{e.getMessage()}));
            }
        }
        return "success";
    }

    private void filterStructs(Set<Long> structIds) {
        DynamicObjectCollection structs = QueryServiceHelper.query((String)"fea_export_task", (String)"taskentry.struct struct", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.taskContext.getExportId()), new QFilter("taskentry.org_id", "=", (Object)this.taskContext.getOrgId()), new QFilter("taskentry.standardentry", "=", (Object)this.standardEntry), new QFilter("taskentry.struct", ">", (Object)0)});
        if (structs.size() == 0) {
            return;
        }
        for (DynamicObject s : structs) {
            structIds.remove(s.getLong("struct"));
        }
    }

    private void handleSingleStruct(AbstractExportProcessor exportProcessor, Set<Long> structIds) {
        DynamicObject structObj = BusinessDataServiceHelper.loadSingleFromCache((Object)this.structId, (String)"fea_datastructure");
        String entity = structObj.getString("entity");
        QFilter fileFilter = new QFilter("filetype", "=", (Object)this.taskContext.getFileType().getValue());
        QFilter entityFilter = new QFilter("bizobj.number", "=", (Object)entity);
        DynamicObject bizConfig = QueryServiceHelper.queryOne((String)"fea_exportpageconfig", (String)"bizobj.number bizobj, filetype, isperiod, pagesize", (QFilter[])new QFilter[]{fileFilter, entityFilter});
        int pageSize = bizConfig.getInt("pagesize");
        Map<String, Map<String, String>> handleConfig = GetExportExtHandleFactory.getExtPluginHandleConfig(this.taskContext.getFileType().getName());
        Map<String, List<IExportExtHandle>> handles = GetExportExtHandleFactory.getExtPluginHandle(handleConfig);
        Map<String, List<DataStructureExportPlanModel>> structureModelMap = ExportPlanStructureProcessor.loadStructure(structIds);
        Map<Long, Long> acctBookMap = this.getAcctBookMap();
        HashSet<Long> bizOrgs = new HashSet<Long>();
        bizOrgs.add(this.taskContext.getOrgId());
        Map bizOrgIds = FeaUtil.getBizOrgIds(bizOrgs, (long)this.taskContext.getBookType());
        FileSingleExportContext singleExportContext = this.createExportContext(exportProcessor, handles, structureModelMap, acctBookMap, bizOrgIds);
        IExportWrite fileWrite = exportProcessor.getFileWrite(this.taskContext, singleExportContext, this.structId);
        List<IExportExtHandle> handleList = exportProcessor.getWriteHandleList(fileWrite);
        CachedDataSet cachedDataSet = exportProcessor.getCachedDataSet(fileWrite, handleList);
        String cacheId = cachedDataSet.getCacheId();
        int rowCount = cachedDataSet.getRowCount();
        DynamicObject exportTask = BusinessDataServiceHelper.loadSingle((Object)this.taskContext.getExportId(), (String)"fea_export_task");
        DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
        DynamicObject taskDetailEntry = taskEntry.stream().filter(obj -> this.taskContext.getTaskId().equals(obj.getPkValue())).findFirst().get();
        DynamicObjectCollection subTaskEntry = taskDetailEntry.getDynamicObjectCollection("subtaskentry");
        ArrayList<Map<String, Object>> splitTaskList = null;
        if (rowCount <= pageSize) {
            splitTaskList = new ArrayList<Map<String, Object>>(1);
            DynamicObject splitTaskObj = subTaskEntry.addNew();
            splitTaskObj.set("detailstruct", (Object)this.structId);
            splitTaskObj.set("beginindex", (Object)0);
            splitTaskObj.set("endindex", (Object)pageSize);
            splitTaskObj.set("taskdetailstatus", (Object)"A");
            Map<String, Object> publishBody = this.createSubTaskPublishMap(cacheId, splitTaskObj, -1);
            splitTaskList.add(publishBody);
        } else {
            double ceil = Math.ceil((double)rowCount * 1.0 / (double)pageSize);
            int pageNum = (int)ceil;
            splitTaskList = new ArrayList(pageNum);
            for (int i = 0; i < pageNum; ++i) {
                DynamicObject dynamicObject = subTaskEntry.addNew();
                dynamicObject.set("seq", (Object)i);
                dynamicObject.set("detailstruct", (Object)this.structId);
                dynamicObject.set("beginindex", (Object)(i * pageSize));
                dynamicObject.set("endindex", (Object)(i * pageSize + pageSize));
                dynamicObject.set("taskdetailstatus", (Object)"A");
                Map<String, Object> publishBody = this.createSubTaskPublishMap(cacheId, dynamicObject, i + 1);
                splitTaskList.add(publishBody);
            }
        }
        try (TXHandle h = TX.requiresNew();){
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{exportTask});
            MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "fi.fea.task_detail_queue");
            for (Map map : splitTaskList) {
                HashMap<String, Object> pubBody = new HashMap<String, Object>(3, 1.0f);
                pubBody.put("msgType", "");
                pubBody.put("pubInstance", Instance.getInstanceId());
                pubBody.put("taskParam", map);
                pub.publishInDbTranscation("fi", pubBody);
            }
            pub.close();
        }
    }

    private Map<String, Object> createSubTaskPublishMap(String cacheId, DynamicObject splitTaskObj, int i2) {
        HashMap<String, Object> publishBody = new HashMap<String, Object>(6, 1.0f);
        publishBody.put("subTask", splitTaskObj);
        publishBody.put("taskContext", this.taskContext);
        publishBody.put("standardEntry", this.standardEntry);
        publishBody.put("cacheId", cacheId);
        publishBody.put("prefixName", this.taskFilePrefix);
        publishBody.put("index", i2);
        return publishBody;
    }
}

