/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.SecurityUtils;
import kd.fi.fea.enums.standard.FileTypeEnum;
import kd.fi.fea.opservice.export.task.SingleTaskContext;
import kd.fi.fea.util.FileUtil;
import kd.fi.fea.util.ThrowableHelper;
import org.apache.commons.io.FilenameUtils;

public class TaskFileUtil {
    private static Log logger = LogFactory.getLog(TaskFileUtil.class);
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");

    public static String getDownloadName() {
        String timeStr = sdf.format(KDDateUtils.now());
        return ResManager.loadKDString((String)"\u5ba1\u8ba1\u6587\u4ef6\u5bfc\u51fa-%s.zip", (String)"TaskFileUtil_1", (String)"fi-fea-business", (Object[])new Object[]{timeStr});
    }

    public static void checkFileExistsByTime(DynamicObjectCollection taskEntry) {
        Date now = new Date();
        for (DynamicObject task : taskEntry) {
            Date expireTime = task.getDate("fileexpiretime");
            if (expireTime == null || now.before(expireTime)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u90e8\u5206\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u3002", (String)"TaskFileUtil_0", (String)"fi-fea-business", (Object[])new Object[0]));
        }
    }

    public static String compressFile(SingleTaskContext taskContext, String taskFilePath, String namePrefix, String sourceFile) {
        String zipFilePath = taskFilePath + File.separator + namePrefix + taskContext.getFileName() + ".zip";
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        ZipOutputStream out = null;
        try {
            fos = new FileOutputStream(SecurityUtils.normalize((String)zipFilePath));
            bos = new BufferedOutputStream(fos);
            out = new ZipOutputStream(bos);
            String entryPath = taskContext.getFileName() + "." + taskContext.getFileType();
            ZipEntry entry = new ZipEntry(entryPath);
            entry.setMethod(8);
            out.putNextEntry(entry);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(SecurityUtils.normalize((String)sourceFile)));){
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
            }
            out.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error("close resource error", (Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error("close resource error", (Throwable)e);
                }
            }
            TaskFileUtil.closeOutStream(fos);
        }
        return zipFilePath;
    }

    public static String handleExportTaskDownloadFile(String exportId, DynamicObject exportTask, Consumer<Integer> update, Supplier<Boolean> stopHandler) {
        DynamicObjectCollection taskEntry = exportTask.getDynamicObjectCollection("taskentry");
        return TaskFileUtil.handleExportTaskDownloadFile(exportId, taskEntry, update, stopHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static String handleExportTaskDownloadFile(String exportId, DynamicObjectCollection taskEntry, Consumer<Integer> update, Supplier<Boolean> stopHandler) {
        fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        totalStep = taskEntry.size();
        for (DynamicObject task : taskEntry) {
            zipfileurl = task.getString("zipfileurl");
            fileExists = fileCache.exists(zipfileurl);
            if (fileExists) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u4efb\u52a1\u90e8\u5206\u6587\u4ef6\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa\u3002", (String)"TaskFileUtil_0", (String)"fi-fea-business", (Object[])new Object[0]));
        }
        totalPercent = 0;
        parentPath = FileUtil.getUserTempPath() + "/ziptmp/" + exportId;
        TaskFileUtil.createDictionary(parentPath);
        try {
            block73: {
                orgFileMap = new HashMap<Long, ArrayList<E>>(5, 1.0f);
                orgNameMap = new HashMap<Long, String>(5, 1.0f);
                taskEntryNameMap = new HashMap<String, String>(5, 1.0f);
                totalStep2 = 0;
                for (DynamicObject task : taskEntry) {
                    block71: {
                        block70: {
                            if (stopHandler != null && stopHandler.get().booleanValue()) {
                                var14_16 = null;
                                return var14_16;
                            }
                            zipfileurl = task.getString("zipfileurl");
                            structId = task.getLong("struct_id");
                            org = task.getDynamicObject("org");
                            orgId = org.getLong("id");
                            orgName = org.getString("name");
                            orgNameMap.put(orgId, orgName);
                            taskEntryNameMap.put(task.getPkValue().toString(), task.getString("zipname"));
                            orgFiles = null;
                            if (orgFileMap.containsKey(orgId)) {
                                orgFiles = (ArrayList<File>)orgFileMap.get(orgId);
                            } else {
                                orgFiles = new ArrayList<File>(5);
                                orgFileMap.put(orgId, orgFiles);
                            }
                            in = null;
                            out = null;
                            in = fileCache.getInputStream(zipfileurl);
                            tmpFile = new File(SecurityUtils.normalize((String)parentPath), FilenameUtils.getName((String)("" + task.getPkValue() + ".zip")));
                            out = new FileOutputStream(tmpFile);
                            buf = new byte[1024];
                            len = 0;
                            while ((len = in.read(buf)) > 0) {
                                out.write(buf, 0, len);
                            }
                            if (structId <= 0L) break block70;
                            orgFiles.add(tmpFile);
                            TaskFileUtil.closeInputStream(in);
                            TaskFileUtil.closeOutStream(out);
                            continue;
                        }
                        try {
                            zipFile = null;
                            try {
                                zipFile = new ZipFile(tmpFile);
                                entries = zipFile.entries();
                                if (!entries.hasMoreElements()) break block71;
                                zipEntry = entries.nextElement();
                                entryIn = zipFile.getInputStream(zipEntry);
                                destFile = new File(SecurityUtils.normalize((String)parentPath), SecurityUtils.normalize((String)(task.getPkValue() + TaskFileUtil.getFileExtension(zipEntry.getName()))));
                                entryOut = null;
                                try {
                                    entryOut = new FileOutputStream(destFile);
                                    while ((len = entryIn.read(buf)) > 0) {
                                        entryOut.write(buf, 0, len);
                                    }
                                    orgFiles.add(destFile);
                                    entryIn.close();
                                }
                                catch (Exception e) {
                                    throw e;
                                }
                                finally {
                                    if (entryOut != null) {
                                        entryOut.close();
                                    }
                                }
                            }
                            catch (Exception e) {
                                throw e;
                            }
                            finally {
                                if (zipFile != null) {
                                    zipFile.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                TaskFileUtil.logger.error("file trans error", (Throwable)e);
                                throw new KDBizException(ThrowableHelper.toString((Exception)e));
                            }
                            catch (Throwable var34_49) {
                                TaskFileUtil.closeInputStream(in);
                                TaskFileUtil.closeOutStream(out);
                                throw var34_49;
                            }
                        }
                    }
                    TaskFileUtil.closeInputStream(in);
                    TaskFileUtil.closeOutStream(out);
                    totalStep2 += orgFiles.size();
                    totalPercent += (int)(1.0 / (double)totalStep * 100.0 * 0.4);
                    if (update == null) continue;
                    update.accept(totalPercent);
                }
                totalPercent = 40;
                if (update != null) {
                    update.accept(totalPercent);
                }
                if (stopHandler != null && stopHandler.get().booleanValue()) {
                    var12_14 = null;
                    return var12_14;
                }
                uploadFile = new File(SecurityUtils.normalize((String)(parentPath + "/" + exportId + ".zip")));
                fos = null;
                bos = null;
                out = null;
                try {
                    block72: {
                        fos = new FileOutputStream(uploadFile);
                        bos = new BufferedOutputStream(fos);
                        out = new ZipOutputStream(bos);
                        for (Map.Entry entry : orgFileMap.entrySet()) {
                            files = (List)entry.getValue();
lbl117:
                            // 3 sources

                            for (File f : files) {
                                if (stopHandler != null && stopHandler.get().booleanValue()) {
                                    out = null;
                                    return out;
                                }
                                break block72;
                            }
                        }
                        break block73;
                    }
                    fileName = TaskFileUtil.getFileNameAndExtension(f.getName());
                    zipEntry = new ZipEntry((String)orgNameMap.get(entry.getKey()) + "/" + (String)taskEntryNameMap.get(fileName[0]) + fileName[1]);
                    zipEntry.setMethod(8);
                    out.putNextEntry(zipEntry);
                    in = new BufferedInputStream(new FileInputStream(f));
                    var24_34 = null;
                    try {
                        n = 0;
                        buf = new byte[1024];
                        while ((n = in.read(buf)) != -1) {
                            out.write(buf, 0, n);
                        }
                    }
                    catch (Throwable var25_39) {
                        var24_34 = var25_39;
                        throw var25_39;
                    }
                    finally {
                        if (in != null) {
                            if (var24_34 != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable var25_38) {
                                    var24_34.addSuppressed(var25_38);
                                }
                            } else {
                                in.close();
                            }
                        }
                    }
                    out.closeEntry();
                    totalPercent += (int)(1.0 / (double)totalStep2 * 100.0 * 0.4);
                    if (update == null) ** GOTO lbl117
                    update.accept(totalPercent);
                    ** GOTO lbl117
                }
                catch (Exception e) {
                    TaskFileUtil.logger.error("zip file error", (Throwable)e);
                    throw new KDBizException(ThrowableHelper.toString((Exception)e));
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            TaskFileUtil.logger.error("close stream error", (Throwable)e);
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            TaskFileUtil.logger.error("close stream error", (Throwable)e);
                        }
                    }
                    TaskFileUtil.closeOutStream(fos);
                }
            }
            totalPercent = 80;
            if (update != null) {
                update.accept(totalPercent);
            }
            downloadUrl = TaskFileUtil.uploadFile(uploadFile.getPath(), TaskFileUtil.getDownloadName(), 1800);
            totalPercent = 100;
            if (update != null) {
                update.accept(totalPercent);
            }
            var17_22 = downloadUrl;
            return var17_22;
        }
        finally {
            FileUtil.deleteKd((File)new File(SecurityUtils.normalize((String)parentPath)));
        }
    }

    public static String uploadFile(String filePath, String fileName, Integer timeout) {
        String fileUrl = "";
        try (FileInputStream fis = new FileInputStream(SecurityUtils.normalize((String)filePath));){
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            fileUrl = fileCache.saveAsUrl(fileName, (InputStream)fis, timeout.intValue());
        }
        catch (Exception e) {
            logger.error("upload file error,", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25", (String)"TaskFileUtil_2", (String)"fi-fea-business", (Object[])new Object[0]));
        }
        return fileUrl;
    }

    public static void delete(List<String> deleteFiles) {
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        for (String url : deleteFiles) {
            try {
                fileCache.remove(url);
            }
            catch (Exception e) {
                logger.warn("delete file from cache fail!", (Throwable)e);
            }
        }
    }

    public static String getFileExtension(String fileName) {
        return !fileName.contains(".") ? "" : fileName.substring(fileName.lastIndexOf("."));
    }

    public static void createDictionary(String parentPath) {
        File f = new File(SecurityUtils.normalize((String)parentPath));
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String[] getFileNameAndExtension(String fileName) {
        String name = fileName.substring(0, fileName.lastIndexOf("."));
        String ext = TaskFileUtil.getFileExtension(fileName);
        return new String[]{name, ext};
    }

    public static void saveDownloadLog(Set<Long> orgIds, long planId) {
        ArrayList<DynamicObject> logs = new ArrayList<DynamicObject>(orgIds.size());
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)"fea_plan", (String)"number, name, group_id");
        long groupId = plan.getLong("group_id");
        DynamicObject group = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)"fea_standard", (String)"filetype");
        String filetype = group.getString("filetype");
        Date beginDate = new Date();
        for (Long ordId : orgIds) {
            DynamicObject exportLog = BusinessDataServiceHelper.newDynamicObject((String)"fea_exportlog");
            exportLog.set("user", (Object)RequestContext.get().getCurrUserId());
            exportLog.set("datetime", (Object)beginDate);
            exportLog.set("filetype", (Object)FileTypeEnum.getName((String)filetype));
            exportLog.set("org", (Object)ordId);
            exportLog.set("plan", (Object)plan);
            logs.add(exportLog);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"fea_exportlog", (DynamicObject[])logs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u4e0b\u8f7d\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25" + operationResult.getMessage());
        }
    }

    private static void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error("close inputstream error", (Throwable)e);
            }
        }
    }

    private static void closeOutStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error("close outputstream error", (Throwable)e);
            }
        }
    }
}

