/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.writer;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.getvaluehandle.AbstractGetValueHandle;
import kd.fi.fea.opservice.export.factory.PropertyCompileFactory;
import kd.fi.fea.opservice.export.formula.FormulaMode;
import kd.fi.fea.opservice.export.formula.IGetValueMode;
import kd.fi.fea.opservice.export.writer.IExportWrite;
import org.apache.poi.ss.formula.functions.T;

public abstract class AbstractExportWrite
implements IExportWrite {
    private static final Log log = LogFactory.getLog(AbstractExportWrite.class);
    protected StructureSingleExportContext context;
    protected static final int NODE_CAPACITY = 1024;
    private static final boolean isLogInfo = true;
    protected Map<String, IGetValueMode> formulaAndValueModeMap;

    public AbstractExportWrite(StructureSingleExportContext context) {
        this.context = context;
        this.complie(context);
    }

    private void complie(StructureSingleExportContext context) {
        this.initFormulaModes();
    }

    @Override
    public abstract void write(Object var1, DataSet var2, List<IExportExtHandle> var3) throws IOException;

    protected void logInfo(String msg) {
        log.info("\u5916\u90e8\u5ba1\u8ba1\u5bfc\u51fa\uff1a" + msg);
    }

    @Override
    public StructureSingleExportContext getContext() {
        return this.context;
    }

    protected Map<String, String> getExpPropNameMap() {
        if (this.context.getExpPropNameMap() == null) {
            int capacity = this.context.getTreeEntryEntity() == null ? 32 : this.context.getTreeEntryEntity().size();
            this.context.setExpPropNameMap(new HashMap<String, String>(capacity));
        }
        return this.context.getExpPropNameMap();
    }

    protected void initFormulaModes() {
        this.formulaAndValueModeMap = new HashMap<String, IGetValueMode>();
        for (DataStructureEntryExportPlanModel structureEntry : this.context.getTreeEntryEntity()) {
            String sourcetpye;
            Map valueMap = structureEntry.getValueMap();
            if (valueMap == null || !"2".equals(sourcetpye = (String)valueMap.get("sourcetype"))) continue;
            String formula = (String)valueMap.get("value");
            this.formulaAndValueModeMap.computeIfAbsent(formula, p -> new FormulaMode(this.context.getEntityType(), formula));
        }
    }

    protected Object parseExpression(Row row, DataStructureEntryExportPlanModel structureEntry) {
        String fullPropName;
        IGetValueMode formulaMode;
        Object elementValue = "";
        Map valueMap = structureEntry.getValueMap();
        String formula = (String)valueMap.get("value");
        if (!StringUtils.isEmpty((String)formula) && (formulaMode = this.formulaAndValueModeMap.get(formula)) != null) {
            try {
                elementValue = formulaMode.GetValue(this.getExpPropNameMap(), row);
            }
            catch (Exception e) {
                if (e instanceof ArithmeticException) {
                    elementValue = 0;
                }
                throw e;
            }
        }
        if (!StringUtils.isEmpty((String)(fullPropName = this.getExpPropNameMap().get(formula)))) {
            elementValue = row.get(fullPropName);
            AbstractGetValueHandle<T> handle = PropertyCompileFactory.getPropertyCompile(this.context.getEntityName(), formula, elementValue);
            if (null != handle) {
                handle.compile();
                elementValue = handle.getFieldValue();
            }
        } else if (formula.endsWith("seq")) {
            elementValue = row.get(formula);
        }
        return elementValue;
    }
}

