/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.factory.DataFormatHandleFactory;
import kd.fi.fea.opservice.export.writer.AbstractExportWrite;
import kd.fi.fea.opservice.export.writer.CSVWrite;

public class CSVExportWrite
extends AbstractExportWrite {
    public CSVExportWrite(StructureSingleExportContext singleExportContext) {
        super(singleExportContext);
    }

    @Override
    public void write(Object writerObj, DataSet dataSet, List<IExportExtHandle> handleList) throws IOException {
        CSVWrite writer = (CSVWrite)writerObj;
        List<DataStructureEntryExportPlanModel> treeentryentity = this.context.getTreeEntryEntity();
        ArrayList<String> headers = new ArrayList<String>(treeentryentity.size());
        for (DataStructureEntryExportPlanModel structureEntry : treeentryentity) {
            headers.add(structureEntry.getValuedesc());
        }
        writer.writeHeader(headers);
        ArrayList<ElementNodeInfo> nodeInfos = new ArrayList<ElementNodeInfo>(1024);
        for (Row row : dataSet) {
            ElementNodeInfo nodeInfo = new ElementNodeInfo(treeentryentity.size());
            for (DataStructureEntryExportPlanModel structureEntry : treeentryentity) {
                Object elementValue = "";
                if (null != structureEntry.getValueMap()) {
                    String sourcetpye;
                    Map valueMap = structureEntry.getValueMap();
                    switch (sourcetpye = (String)valueMap.get("sourcetype")) {
                        case "1": {
                            elementValue = valueMap.get("value");
                            break;
                        }
                        case "2": {
                            elementValue = this.parseExpression(row, structureEntry);
                            break;
                        }
                        case "3": {
                            break;
                        }
                    }
                }
                for (IExportExtHandle handle : handleList) {
                    elementValue = handle.parseExpression(this.context, row, structureEntry, nodeInfo, elementValue);
                }
                AbstractDataFormatHandle dataFormatHandle = DataFormatHandleFactory.getDataFormatHandle(structureEntry, elementValue);
                if (null != dataFormatHandle) {
                    elementValue = dataFormatHandle.compile().getFieldValue();
                }
                nodeInfo.addChildValues(elementValue);
            }
            nodeInfos.add(nodeInfo);
            if (nodeInfos.size() % 10000 != 0) continue;
            for (IExportExtHandle handle : handleList) {
                handle.buildElement(this.context, null, nodeInfos);
            }
            writer.writeNodes(nodeInfos);
            nodeInfos.clear();
        }
        if (nodeInfos.size() > 0) {
            for (IExportExtHandle handle : handleList) {
                handle.buildElement(this.context, null, nodeInfos);
            }
            writer.writeNodes(nodeInfos);
            nodeInfos.clear();
        }
    }
}

