/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.writer;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import kd.fi.fea.model.ElementNodeInfo;

public class CSVWrite
implements Closeable {
    private OutputStreamWriter ow = null;
    private String wordSplit = ",";

    public void setWordSplit(String wordSplit) {
        this.wordSplit = wordSplit;
    }

    public CSVWrite(OutputStreamWriter ow) {
        this.ow = ow;
    }

    public void writeHeader(List<String> headers) throws IOException {
        int j = 0;
        for (String header : headers) {
            if (j > 0) {
                this.ow.write(this.wordSplit);
            }
            this.ow.write(header);
            ++j;
        }
        this.ow.write("\r\n");
        this.ow.flush();
    }

    public void writeNodes(List<ElementNodeInfo> nodeInfos) throws IOException {
        for (ElementNodeInfo nodeInfo : nodeInfos) {
            int j = 0;
            for (Object fieldVal : nodeInfo.getChildValues()) {
                if (j > 0) {
                    this.ow.write(this.wordSplit);
                }
                if (fieldVal == null) {
                    this.ow.write("");
                } else if (fieldVal instanceof String) {
                    if (this.wordSplit.equals("|")) {
                        fieldVal = ((String)fieldVal).replaceAll("\\|", " ");
                    }
                    fieldVal = ((String)fieldVal).replaceAll("\"", "'");
                    fieldVal = ((String)fieldVal).replaceAll("\r\n", " ");
                    fieldVal = ((String)fieldVal).replaceAll("\n", " ");
                    fieldVal = ((String)fieldVal).replaceAll("\t", " ");
                    this.ow.write("\"" + fieldVal + "\"");
                } else {
                    this.ow.write(fieldVal.toString());
                }
                ++j;
            }
            this.ow.write("\r\n");
        }
        this.ow.flush();
    }

    @Override
    public void close() {
        if (this.ow != null) {
            try {
                this.ow.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.ow.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

