/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.opservice.export.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.util.StringUtils;
import kd.fi.fea.model.DataStructureEntryExportPlanModel;
import kd.fi.fea.model.ElementNodeInfo;
import kd.fi.fea.opservice.export.builder.context.StructureSingleExportContext;
import kd.fi.fea.opservice.export.builder.ext.IExportExtHandle;
import kd.fi.fea.opservice.export.builder.format.AbstractDataFormatHandle;
import kd.fi.fea.opservice.export.factory.DataFormatHandleFactory;
import kd.fi.fea.opservice.export.writer.AbstractExportWrite;
import kd.fi.fea.opservice.export.writer.FeaXMLWriter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlExportWrite
extends AbstractExportWrite {
    private FeaXMLWriter writer;

    public XmlExportWrite(StructureSingleExportContext context) {
        super(context);
    }

    @Override
    public void write(Object writerObj, DataSet dataSet, List<IExportExtHandle> handleList) throws IOException {
        this.writer = (FeaXMLWriter)writerObj;
        this.execute(this.writer, dataSet, handleList);
    }

    private void execute(FeaXMLWriter writer, DataSet dataSet, List<IExportExtHandle> handleList) throws IOException {
        if (dataSet == null) {
            return;
        }
        ArrayList<ElementNodeInfo> nodeInfos = new ArrayList<ElementNodeInfo>(1024);
        List<DataStructureEntryExportPlanModel> treeentryentity = this.context.getTreeEntryEntity();
        for (Row row : dataSet) {
            ElementNodeInfo nodeInfo = new ElementNodeInfo(treeentryentity.size());
            for (DataStructureEntryExportPlanModel structureEntry : treeentryentity) {
                String valuedesc = structureEntry.getValuedesc();
                Object elementValue = "";
                if (null != structureEntry.getValueMap()) {
                    String sourcetpye;
                    Map valueMap = structureEntry.getValueMap();
                    switch (sourcetpye = (String)valueMap.get("sourcetype")) {
                        case "1": {
                            elementValue = valueMap.get("value");
                            break;
                        }
                        case "2": {
                            elementValue = this.parseExpression(row, structureEntry);
                            break;
                        }
                        case "3": {
                            Map map = (Map)valueMap.get("value");
                            break;
                        }
                    }
                }
                for (IExportExtHandle handle : handleList) {
                    elementValue = handle.parseExpression(this.context, row, structureEntry, nodeInfo, elementValue);
                }
                AbstractDataFormatHandle dataFormatHandle = DataFormatHandleFactory.getDataFormatHandle(structureEntry, elementValue);
                if (null != dataFormatHandle) {
                    elementValue = dataFormatHandle.compile().getFieldValue();
                }
                String val = "";
                if (elementValue != null && StringUtils.isEmpty((String)(val = elementValue.toString()))) {
                    val = "";
                }
                nodeInfo.addChildNode(valuedesc, val);
            }
            nodeInfos.add(nodeInfo);
            if (nodeInfos.size() % 10000 != 0) continue;
            List<Element> elements = this.buildElement(nodeInfos);
            for (IExportExtHandle handle : handleList) {
                elements = handle.buildElement(this.context, elements, nodeInfos);
            }
            this.writeElement(writer, elements);
            nodeInfos.clear();
        }
        if (nodeInfos.size() > 0) {
            List<Element> elements = this.buildElement(nodeInfos);
            for (IExportExtHandle handle : handleList) {
                elements = handle.buildElement(this.context, elements, nodeInfos);
            }
            this.writeElement(writer, elements);
        }
    }

    private List<Element> buildElement(List<ElementNodeInfo> nodeInfos) {
        ArrayList<Element> elementList = new ArrayList<Element>(10);
        for (ElementNodeInfo nodeInfo : nodeInfos) {
            Element element = DocumentHelper.createElement((String)this.context.getBillName());
            for (Map.Entry entry : nodeInfo.getAllNodes().entrySet()) {
                String value = (String)entry.getValue();
                if (!StringUtils.isEmpty((String)value)) {
                    element.addElement((String)entry.getKey()).setText(value);
                    continue;
                }
                element.addElement((String)entry.getKey()).clearContent();
            }
            elementList.add(element);
        }
        return elementList;
    }

    private void writeElement(FeaXMLWriter writer, List<Element> elementList) throws IOException {
        for (int i = 0; i < elementList.size(); ++i) {
            writer.write(elementList.get(i));
            if (i % 1000 != 0) continue;
            writer.flush();
        }
        writer.flush();
    }
}

