/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.accsys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fea.accsys.AccountBookInfo;
import kd.fi.fea.cache.CacheHelper;
import kd.fi.fea.cache.CacheKey;
import kd.fi.fea.cache.CacheModule;
import kd.fi.fea.cache.DistributeCache;
import kd.fi.fea.cache.ThreadCacheKey;
import kd.fi.fea.enums.PermissonType;
import kd.fi.fea.model.DSField;
import kd.fi.fea.util.AcctTableComAssistUtil;

public class AccSysUtil {
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;

    private AccSysUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(org, bookType);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType, long periodId) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType, periodId), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(org, bookType);
            if (bookId == null || bookId.equals(0L)) {
                return null;
            }
            AccountBookInfo accountBookInfo = new AccountBookInfo(bookId);
            long acctTableId = AccountRefUtils.getCurPeriodAccountTableId((long)org, (long)bookType, (long)periodId);
            if (acctTableId != 0L) {
                accountBookInfo.setAccounttable(acctTableId);
                DSField comAssist = AcctTableComAssistUtil.queryAcctTableComAssist(acctTableId);
                accountBookInfo.setComAssist(comAssist);
            }
            return accountBookInfo;
        });
    }

    public static List<AccountBookInfo> getBookFromAccSys(Set<Long> orgSet, long bookType) {
        ArrayList<AccountBookInfo> result = new ArrayList<AccountBookInfo>();
        for (Long org : orgSet) {
            AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys(org, bookType);
            if (bookInfo == null) continue;
            result.add(bookInfo);
        }
        return result;
    }

    private static Long getBookIdFromCache(long org, long bookType) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(org, bookType), () -> {
            long result;
            String key = CacheKey.getKey(org, bookType);
            DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org", "=", (Object)org);
                QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
                DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book == null) {
                    return null;
                }
                result = book.getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    public static List<Long> getAllBookTypeByOrg(long orgId) {
        DataSet bookTypeSet;
        ArrayList<Long> bookTypeList = new ArrayList<Long>();
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter org = new QFilter("org", "=", (Object)orgId);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds));
        }
        if ((bookTypeSet = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getAllBookTypeByOrg", (String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")}, (String)"bookstype.accounttype")) != null) {
            for (Row row : bookTypeSet) {
                bookTypeList.add(row.getLong("bookstype"));
            }
        }
        return bookTypeList;
    }

    public static List<Long> getBookTypeDataPermission(List<Long> orgs) {
        QFilter permission = PermissionServiceHelper.getDataPermission((long)Long.parseLong(RequestContext.get().getUserId()), null, (String)"bd_accountbookstype", orgs);
        if (null != permission) {
            ArrayList<Long> ids = new ArrayList<Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getBookTypeCombo", (String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{permission}, null);){
                for (Row row : ds) {
                    ids.add(row.getLong("id"));
                }
            }
            return ids;
        }
        return null;
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static List<Long> getAllBookFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("id"));
            }
            return idList;
        });
    }

    public static List<Long> getAcctOrgPkList(String entityId, boolean isIncludeUnit, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"gl").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = isIncludeUnit ? AccSysUtil.getViewOrgMap() : AccSysUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        List permOrgs = new ArrayList();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        HashSet permChildOrg = new HashSet(orgSet);
        if (isIncludeUnit) {
            Map<Long, Set> filteredViewOrgMap = viewOrgMap.entrySet().stream().filter(x -> {
                Set value = (Set)x.getValue();
                value.retainAll(permChildOrg);
                return !value.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(filteredViewOrgMap.keySet());
            LinkedHashSet parentOrgs = new LinkedHashSet();
            for (Map.Entry<Long, Set> entry : filteredViewOrgMap.entrySet()) {
                List<Object> rs = new LinkedList();
                Set orgs = entry.getValue();
                orgs.retainAll(orgSet);
                if (!orgs.isEmpty()) {
                    rs = AccSysUtil.getParentOrgId(orgStructureByViews.copy().filter("view = " + entry.getKey()), orgs, false);
                }
                parentOrgs.addAll(rs);
            }
            if (!permOrgRs.hasAllOrgPerm()) {
                parentOrgs.retainAll(permOrgs);
            }
            parentOrgs.addAll(orgSet);
            orgSet = parentOrgs;
        }
        return new ArrayList<Long>(orgSet);
    }

    private static List<Long> getParentOrgId(DataSet orgDataSet, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
        if (includeChildSelf) {
            result.addAll(childList);
        }
        return result;
    }

    private static void getParentOrgIdHelper(Set<Long> childList, LinkedList<Long> result, DataSet orgDataSet) {
        LinkedHashSet<Long> parentOrgId = new LinkedHashSet<Long>();
        String childStr = "(0)";
        if (!childList.isEmpty()) {
            childStr = childList.toString().replace('[', '(').replaceFirst("]", ")");
        }
        try (DataSet parentOrgSet = orgDataSet.copy().filter("org in " + childStr);){
            for (Row row : parentOrgSet) {
                Long parent = row.getLong("parent");
                if (parent == null || parent == 0L) continue;
                parentOrgId.add(parent);
            }
            if (parentOrgId.size() > 0) {
                for (Long pid : parentOrgId) {
                    if (result.contains(pid)) continue;
                    result.addFirst(pid);
                }
                AccSysUtil.getParentOrgIdHelper(parentOrgId, result, orgDataSet);
            }
        }
    }

    private static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Set<Long>> getViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    public static Map<Long, Map<Long, List<Long>>> getViewOrgBTMap() {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        Map<Long, Map<Long, List<Long>>> statViewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        mainViewOrgBTMap.putAll(statViewOrgBTMap);
        return mainViewOrgBTMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getMainViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(true);
    }

    private static Map<Long, Map<Long, List<Long>>> getStatViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(false);
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        cache.remove("accsys-mainvieworgbooktype-cache");
        cache.remove("accsys-statvieworgbooktype-cache");
        String str = cache.get(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache");
        if (str != null) {
            Map map = (Map)AccSysUtil.fromSerializedString(str);
            return map;
        }
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet finish = bookDataSet.join(viewDataSet, JoinType.INNER).on("accountingsys", "accountingsys").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                HashMap orgBookTypeMap = (HashMap)result.get(mainView);
                if (null != orgBookTypeMap) {
                    ArrayList<Long> bookTypeList = (ArrayList<Long>)orgBookTypeMap.get(org);
                    if (null != bookTypeList) {
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        CacheHelper.getDistributeCache(CacheModule.accSys).put(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache", AccSysUtil.toSerializedString(result));
        return result;
    }

    public static Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    private static DataSet getOrgStructureByViews(Collection<Long> views) {
        QFilter mainViewFilter = new QFilter("view", "in", views);
        return QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent,view", (QFilter[])new QFilter[]{mainViewFilter}, null);
    }

    public static List<Long> getPeriodIds(Long begin, Long end, boolean isadjust) {
        if (end == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(end / TYPE_PERIOD_L));
        QFilter beginFilter = new QFilter("id", ">=", (Object)begin);
        QFilter endFilter = new QFilter("id", "<=", (Object)end);
        QFilter adjustFilter = null;
        if (!isadjust) {
            adjustFilter = new QFilter("isadjustperiod", "=", (Object)false);
        }
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, beginFilter, endFilter, adjustFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        return result;
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }
}

