/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.fi.fea.cache.AppBookConfig;

public class FeaCache {
    private static final String feaConfigCacheKey = "fi-fea-feaconfigs";
    private static final Log log = LogFactory.getLog(FeaCache.class);
    private static final Map<String, AppBookConfig> appConfig = new HashMap<String, AppBookConfig>();
    private static final Set<String> acctConfig = new HashSet<String>();
    private static final Map<String, String> billBookTypeFieldCache = new HashMap<String, String>();
    private static final Map<String, String> billBookFieldCache = new HashMap<String, String>();
    private static final Map<String, String> billEntityAppNumCache = new HashMap<String, String>();
    private static final ThreadLocal<Map<String, Set<Long>>> bizBookIdMap = new ThreadLocal();

    public static Map<String, AppBookConfig> getAppConfig() {
        return appConfig;
    }

    public static Set<String> getAcctConfig() {
        return acctConfig;
    }

    public static Set<Long> getBizBookIds(String appNumber) {
        Map<String, Set<Long>> bookMap = bizBookIdMap.get();
        if (bookMap == null) {
            bizBookIdMap.set(new HashMap());
        }
        return bizBookIdMap.get().get(appNumber);
    }

    public static void setBizBookIds(String key, Set<Long> bizBookIds) {
        Set<Long> ids;
        Map<String, Set<Long>> bookMap = bizBookIdMap.get();
        if (bookMap == null) {
            bizBookIdMap.set(new HashMap());
        }
        if ((ids = bizBookIdMap.get().get(key)) == null) {
            bizBookIdMap.get().put(key, bizBookIds);
        }
    }

    public static String getAcctBookField(String billType, String searchType) {
        return FeaCache.getAcctBookField(billType, searchType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAcctBookField(String billType, String searchType, EntityType firstEntity) {
        String cacheKey = billType + searchType;
        if (firstEntity != null) {
            cacheKey = cacheKey + firstEntity.getName();
        }
        if (billBookTypeFieldCache.containsKey(cacheKey)) {
            return billBookTypeFieldCache.get(cacheKey);
        }
        Class<FeaCache> clazz = FeaCache.class;
        synchronized (FeaCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookField = FeaCache.searchField((IDataEntityType)meta, searchType, null, selectEntitys);
            billBookTypeFieldCache.put(cacheKey, bookField);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return bookField;
        }
    }

    public static String getBillBookTypeField(String billType) {
        return FeaCache.getBillBookTypeField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookTypeField(String billType, EntityType firstEntity) {
        String cacheKey = billType;
        if (firstEntity != null) {
            cacheKey = cacheKey + firstEntity.getName();
        }
        if (billBookTypeFieldCache.containsKey(cacheKey)) {
            return billBookTypeFieldCache.get(cacheKey);
        }
        Class<FeaCache> clazz = FeaCache.class;
        synchronized (FeaCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            String bookTypeEntity = FeaCache.appConfig.get((Object)appNum).bookTypeEntity;
            if (bookTypeEntity == null) {
                billBookTypeFieldCache.put(cacheKey, null);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookTypeField = FeaCache.searchField((IDataEntityType)meta, bookTypeEntity, null, selectEntitys);
            billBookTypeFieldCache.put(cacheKey, bookTypeField);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bookTypeField;
        }
    }

    public static String getBillBookField(String billType) {
        return FeaCache.getBillBookField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookField(String billType, EntityType firstEntity) {
        if (billBookFieldCache.containsKey(billType)) {
            return billBookFieldCache.get(billType);
        }
        Class<FeaCache> clazz = FeaCache.class;
        synchronized (FeaCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String bookEntity = FeaCache.appConfig.get((Object)appNum).bookEntity;
            if (bookEntity == null) {
                billBookFieldCache.put(billType, null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookField = FeaCache.searchField((IDataEntityType)meta, bookEntity, null, selectEntitys);
            billBookFieldCache.put(billType, bookField);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bookField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillEntityAppNumber(String billType) {
        if (billEntityAppNumCache.containsKey(billType)) {
            return billEntityAppNumCache.get(billType);
        }
        Class<FeaCache> clazz = FeaCache.class;
        synchronized (FeaCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return appNum;
        }
    }

    private static String searchField(IDataEntityType meta, String entityNumber, String prefix, Set<String> selectEntitys) {
        String fieldName = null;
        for (IDataEntityProperty property : meta.getProperties()) {
            BasedataProp bdProp;
            if (property instanceof EntryProp) {
                IDataEntityType childEntity;
                if (selectEntitys != null && !selectEntitys.contains(property.getName()) || StringUtils.isBlank((String)(childEntity = ((EntryProp)property).getItemType()).getAlias())) continue;
                String epx = null;
                epx = prefix == null ? property.getName() : prefix + "." + property.getName();
                fieldName = FeaCache.searchField(childEntity, entityNumber, epx, selectEntitys);
                if (fieldName == null) continue;
                return fieldName;
            }
            if (!(property instanceof BasedataProp) || !entityNumber.equalsIgnoreCase((bdProp = (BasedataProp)property).getBaseEntityId())) continue;
            if (prefix != null) {
                return prefix + "." + property.getName();
            }
            return property.getName();
        }
        return fieldName;
    }

    private static boolean is_a_word(String str) {
        str = str.trim();
        Pattern p = Pattern.compile("^[A-Za-z]+$");
        Matcher m = p.matcher(str);
        return m.matches();
    }

    static {
        appConfig.put("fa", new AppBookConfig("fa", "fa_assetbook", "fa_depreuse", "t_bd_assetbookentry", "org", "depreuse"));
        appConfig.put("cal", new AppBookConfig("cal", "cal_bd_costaccount", null, "t_bd_costaccountentry", "calorg", null));
        appConfig.put("ar", new AppBookConfig("ar", "ar_policy", "ar_policytype", "t_bd_policybookentry", "org", "policytype"));
        acctConfig.add("bd_accountbookstype");
        acctConfig.add("gl_accountbook");
    }
}

