/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.fi.fea.model.DataType;

public class ElementNodeInfo {
    private final Map<String, String> nodeAndValMap;
    private final Map<String, Object> flexItemTypeAndValMap;
    private Long assgrpId;
    private Long accountId;
    private int assgrpIndex;
    private DataType dataType;
    private Long comAssistVal;
    private final List<Object> values;

    public ElementNodeInfo(int capacity) {
        this.nodeAndValMap = new LinkedHashMap<String, String>(capacity);
        this.values = new ArrayList<Object>(capacity);
        this.flexItemTypeAndValMap = new HashMap<String, Object>(capacity);
        this.assgrpIndex = -1;
    }

    public void addChildNode(String key, String value) {
        this.nodeAndValMap.put(key, value);
    }

    public void addChildValues(Object value) {
        this.values.add(value);
    }

    public String getChildNode(String key) {
        return this.nodeAndValMap.get(key);
    }

    public List<Object> getChildValues() {
        return this.values;
    }

    public Map<String, String> getAllNodes() {
        return this.nodeAndValMap;
    }

    public Map<String, Object> getFlexItemTypeValMap() {
        return this.flexItemTypeAndValMap;
    }

    public void addFlexItemTypeAndVal(String flexItemType, Object val) {
        this.flexItemTypeAndValMap.put(flexItemType, val);
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public static String getTypeAndIdKey(String flexItemType, Long id) {
        return flexItemType + "-" + id;
    }

    public Long getAssgrpId() {
        return this.assgrpId;
    }

    public void setAssgrpId(Long assgrpId) {
        this.assgrpId = assgrpId;
    }

    public int getAssgrpIndex() {
        return this.assgrpIndex;
    }

    public void setAssgrpIndex(int assgrpIdx) {
        this.assgrpIndex = assgrpIdx;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public Long getComAssistVal() {
        return this.comAssistVal;
    }

    public void setComAssistVal(Long comAssistVal) {
        this.comAssistVal = comAssistVal;
    }
}

