/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.util;

import java.util.ArrayList;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.fi.fea.model.FeaOpLogInfo;

public class FeaOperateLogUtil {
    public static void addLog(FeaOpLogInfo logInfo) {
        LogServiceHelper.addLog((AppLogInfo)FeaOperateLogUtil.convertLog(logInfo));
    }

    public static void addBatchLog(List<FeaOpLogInfo> logInfos) {
        LogServiceHelper.addBatchLog(FeaOperateLogUtil.convertBatchLogs(logInfos));
    }

    public static FeaOpLogInfo buildOpLog(String entityName, String OpName, String description, long orgId) {
        FeaOpLogInfo appLogInfo = new FeaOpLogInfo();
        String appId = EntityMetadataCache.getDataEntityType((String)entityName).getAppId();
        String id = AppMetadataCache.getAppInfo((String)appId).getId();
        appLogInfo.setBizAppID(id);
        appLogInfo.setBizObjID(entityName);
        appLogInfo.setOpDescription(description);
        appLogInfo.setOpKey("export");
        appLogInfo.setOpName(OpName);
        appLogInfo.setOpTime(TimeServiceHelper.now());
        appLogInfo.setOrgID(orgId);
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        appLogInfo.setClientIP(RequestContext.get().getLoginIP());
        appLogInfo.setClientType(RequestContext.get().getClient());
        return appLogInfo;
    }

    private static List<AppLogInfo> convertBatchLogs(List<FeaOpLogInfo> logInfos) {
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(logInfos.size());
        for (FeaOpLogInfo logInfo : logInfos) {
            appLogInfoList.add(FeaOperateLogUtil.convertLog(logInfo));
        }
        return appLogInfoList;
    }

    private static AppLogInfo convertLog(FeaOpLogInfo logInfo) {
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setBizAppID(logInfo.getBizAppID());
        appLogInfo.setBizObjID(logInfo.getBizObjID());
        appLogInfo.setOpDescription(logInfo.getOpDescription());
        appLogInfo.setOpName(logInfo.getOpKey(), logInfo.getOpName());
        appLogInfo.setOpTime(logInfo.getOpTime());
        appLogInfo.setOrgID(logInfo.getOrgID());
        appLogInfo.setUserID(logInfo.getUserID());
        appLogInfo.setClientIP(logInfo.getClientIP());
        appLogInfo.setClientName(logInfo.getClientName());
        appLogInfo.setClientType(logInfo.getClientType());
        return appLogInfo;
    }
}

