/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fea.util.ContextUtil;
import kd.fi.fea.util.FeaUtil;

public class FeaPermissionUtils {
    private static final Log logger = LogFactory.getLog(FeaPermissionUtils.class);
    public static final String AUDITID = "47162f66000000ac";
    public static final String NEWID = "47156aff000000ac";
    public static final String VIEWID = "47150e89000000ac";
    private static final String ORGNAME = "org.name";
    private static final String ID = "id";
    private static final String ORG_ID = "org.id";
    private static final String ORGNUMBER = "org.number";
    private static final String USERORG_ID = "useorg.id";

    public static List<Long> getLeafOrgs(List<Long> orgIds, String orgViewType) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)orgViewType);
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "in", orgIds);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        logger.info("\u5f00\u59cb\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)ORG_ID, (QFilter[])filters);
        logger.info("\u7ed3\u675f\u67e5\u8be2\u53f6\u5b50\u7ec4\u7ec7");
        ArrayList<Long> leafOrgs = new ArrayList<Long>();
        for (DynamicObject s : orgs) {
            leafOrgs.add(s.getLong(ORG_ID));
        }
        leafOrgs.sort((v1, v2) -> v1.compareTo((Long)v2));
        logger.info(String.format("\u8ddf\u8e2a\u8fd4\u56de\u7684\u53f6\u5b50\u7ec4\u7ec7\u662f\u4ec0\u4e48: %s", FeaUtil.join(leafOrgs, ",")));
        return leafOrgs;
    }

    public static void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent e, String pageEntityId) {
        String field = e.getFieldName();
        if (ORGNAME.equals(field) || ORGNUMBER.equals(field) || ORG_ID.equals(field)) {
            List<Long> orgIds = FeaPermissionUtils.getPermissionOrgs(pageEntityId);
            e.getQfilters().add(new QFilter(ID, "in", orgIds));
        }
    }

    public static List<ComboItem> getAllEnablePermissionOrgsCombos(String entityId) {
        List<Long> permissionOrgIds = FeaPermissionUtils.getViewPermissionLeafOrg(entityId);
        LinkedHashSet<Long> set = new LinkedHashSet<Long>(permissionOrgIds.size());
        set.addAll(permissionOrgIds);
        permissionOrgIds.clear();
        permissionOrgIds.addAll(set);
        return FeaPermissionUtils.getLeafOrgCombos(permissionOrgIds);
    }

    public static List<ComboItem> getLeafOrgCombos(List<Long> allPermissionOrgs) {
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter defaultViewFilter = new QFilter("view.isdefault", "=", (Object)true);
        QFilter idFilter = new QFilter("org", "in", allPermissionOrgs);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        QFilter[] filters = new QFilter[]{treeTypeFilter, defaultViewFilter, idFilter, leafFilter};
        DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.name", (QFilter[])filters);
        LinkedHashMap<String, String> orgIdAndNameMap = new LinkedHashMap<String, String>();
        for (DynamicObject s : orgs) {
            orgIdAndNameMap.put(Long.valueOf(s.getLong(ORG_ID)).toString(), s.getString(ORGNAME));
        }
        Set entrySet = orgIdAndNameMap.entrySet();
        ArrayList<ComboItem> leafOrgs = new ArrayList<ComboItem>(entrySet.size());
        for (Map.Entry m : entrySet) {
            ComboItem c = new ComboItem();
            c.setValue((String)m.getKey());
            c.setCaption(new LocaleString((String)m.getValue()));
            leafOrgs.add(c);
        }
        return leafOrgs;
    }

    public static List<Long> getViewPermissionLeafOrg(String entityNum) {
        List allPermissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)ContextUtil.getUserId(), (String)"fea", (String)entityNum, (String)VIEWID);
        return FeaPermissionUtils.getLeafOrgs(allPermissionOrgs, "10");
    }

    public static List<Long> getPermissionOrgs(String entityId) {
        Long userID = ContextUtil.getUserId();
        List allPermissionOrgs = PermissionServiceHelper.getAllPermissionOrgs((Long)userID, (String)"fea", (String)entityId, (String)VIEWID);
        List<Long> permOrgs = FeaPermissionUtils.getLeafOrgs(allPermissionOrgs, "10");
        return permOrgs;
    }
}

