/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fea.enums.datatype.DataTypeEnum;
import org.apache.commons.lang3.math.NumberUtils;

public class FeaUtil {
    public static final String APP_ID = "fea";
    public static final String BTN_TREE_NEW = "btnnew";
    public static final String BTN_TREE_EDIT = "btnedit";
    public static final String BTN_TREE_DEL = "btndel";
    private static final ThreadLocal<Map<String, Set<Long>>> orgRelationMap = new ThreadLocal();

    public static List<ComboItem> buildPropComboItems(Set<String> entityIds, MainEntityType srcMainEntityType, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        FeaUtil.searchBDField(entityIds, (EntityType)srcMainEntityType, items, null, null, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub);
        items.sort(new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem arg0, ComboItem arg1) {
                String arg0Str = arg0.getValue();
                String arg1Str = arg1.getValue();
                if ("".equals(arg0Str)) {
                    return -1;
                }
                if ("".equals(arg1Str)) {
                    return 1;
                }
                if (arg0Str.indexOf(".") >= 0 && arg1Str.indexOf(".") < 0) {
                    return 1;
                }
                if (arg0Str.indexOf(".") < 0 && arg1Str.indexOf(".") >= 0) {
                    return -1;
                }
                return arg1.getValue().compareTo(arg0.getValue());
            }
        });
        return items;
    }

    private static void searchBDField(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                String parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else {
                    parentKeySub = prop.getName();
                }
                FeaUtil.searchBDField(entityIds, subEntityType, items, parentNameSub, parentKeySub, searchSubEntrySubEntitySub, searchSubEntry, searchSubEntrySubEntitySub);
                continue;
            }
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            String parentNameNext = parentName + "." + bdProp.getDisplayName().toString();
            if (parentName == null) {
                parentNameNext = bdProp.getDisplayName().toString();
            }
            if (entityIds.contains(bdProp.getBaseEntityId()) && StringUtils.isNotEmpty((CharSequence)prop.getAlias())) {
                ComboItem item = new ComboItem();
                if (parentKey != null) {
                    item.setValue(parentKey + "." + bdProp.getName());
                } else {
                    item.setValue(bdProp.getName());
                }
                if (parentName != null) {
                    item.setCaption(new LocaleString(parentNameNext));
                } else {
                    parentNameNext = entityType.getDisplayName().toString() + "." + bdProp.getDisplayName().toString();
                    item.setCaption(new LocaleString(parentNameNext));
                }
                items.add(item);
                continue;
            }
            if (!searchSubEntity || !StringUtils.isNotEmpty((CharSequence)prop.getAlias()) || bdProp instanceof FlexProp) continue;
            FeaUtil.searchBDField(entityIds, (EntityType)EntityMetadataCache.getDataEntityType((String)bdProp.getComplexType().getName()), items, parentNameNext, bdProp.getName(), false, false, false);
        }
    }

    public static String validateDataType(Map<String, Object> dataType, String value) {
        String type = (String)dataType.get("type");
        if (DataTypeEnum.STRING.getValue().equals(type)) {
            String lengthRange = (String)dataType.get("lengthrange");
            int length = Integer.parseInt(String.valueOf(dataType.get("length")));
            if (String.valueOf(NumberUtils.INTEGER_ZERO).equals(lengthRange)) {
                if (value.length() != length) {
                    return ResManager.loadKDString((String)"\u503c\u7684\u957f\u5ea6\u4e0d\u4e3a\u89c4\u5b9a\u503c\u3002", (String)"FeaUtil_0", (String)"fi-fea-common", (Object[])new Object[0]);
                }
            } else if (value.length() > length) {
                return ResManager.loadKDString((String)"\u503c\u7684\u957f\u5ea6\u6700\u5927\u503c\u8bbe\u7f6e\u8d85\u8fc7\u89c4\u5b9a\u6700\u5927\u503c\u3002", (String)"FeaUtil_1", (String)"fi-fea-common", (Object[])new Object[0]);
            }
        } else {
            if (DataTypeEnum.DATE.getValue().equals(type) || DataTypeEnum.TIME.getValue().equals(type)) {
                String formatter = (String)dataType.get("formatter");
                SimpleDateFormat dt = new SimpleDateFormat(formatter);
                try {
                    dt.parse(value);
                }
                catch (ParseException e) {
                    return ResManager.loadKDString((String)"\u503c\u7684\u683c\u5f0f\u4e0d\u6ee1\u8db3\u89c4\u5b9a\u683c\u5f0f\u8981\u6c42\u3002", (String)"FeaUtil_2", (String)"fi-fea-common", (Object[])new Object[0]);
                }
            }
            if (!DataTypeEnum.ANYURI.getValue().equals(type)) {
                if (DataTypeEnum.DOUBLE.getValue().equals(type) || DataTypeEnum.DECIMAL.getValue().equals(type)) {
                    int totallength = Integer.parseInt(String.valueOf(dataType.get("totallength")));
                    int decimallength = Integer.parseInt(String.valueOf(dataType.get("decimallength")));
                    int index = value.indexOf(46);
                    try {
                        if (Double.parseDouble(value) / Math.pow(10.0, totallength - decimallength) > NumberUtils.DOUBLE_ZERO) {
                            return ResManager.loadKDString((String)"\u503c\u7684\u603b\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u603b\u4f4d\u6570\u3002", (String)"FeaUtil_3", (String)"fi-fea-common", (Object[])new Object[0]);
                        }
                    }
                    catch (Exception e) {
                        return ResManager.loadKDString((String)"\u503c\u4e0d\u662f%s\u7c7b\u578b\u3002", (String)"FeaUtil_9", (String)"fi-fea-common", (Object[])new Object[]{type});
                    }
                    if (index != -1 && value.substring(index + 1).length() > decimallength) {
                        return ResManager.loadKDString((String)"\u503c\u7684\u5c0f\u6570\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u5c0f\u6570\u4f4d\u6570\u3002", (String)"FeaUtil_6", (String)"fi-fea-common", (Object[])new Object[0]);
                    }
                } else {
                    try {
                        if (DataTypeEnum.INT.getValue().equals(type)) {
                            Integer.parseInt(value);
                        } else if (DataTypeEnum.NONNEGATIVEINTEGER.getValue().equals(type)) {
                            if (Integer.parseInt(value) < 0) {
                                return ResManager.loadKDString((String)"\u503c\u5c0f\u4e8e0\u3002", (String)"FeaUtil_7", (String)"fi-fea-common", (Object[])new Object[0]);
                            }
                        } else if (DataTypeEnum.SHORT.getValue().equals(type)) {
                            Short.parseShort(value);
                        }
                    }
                    catch (Exception e) {
                        return ResManager.loadKDString((String)"\u503c\u4e0d\u662f%s\u7c7b\u578b\u3002", (String)"FeaUtil_9", (String)"fi-fea-common", (Object[])new Object[]{type});
                    }
                    int integerlength = Integer.parseInt(String.valueOf(dataType.get("integerlength")));
                    if (value.length() > integerlength) {
                        return ResManager.loadKDString((String)"\u503c\u7684\u4f4d\u6570\u8d85\u8fc7\u89c4\u5b9a\u4f4d\u6570\u3002", (String)"FeaUtil_8", (String)"fi-fea-common", (Object[])new Object[0]);
                    }
                }
            }
        }
        return null;
    }

    public static DataSet gainSumSet(DataSet ds, String[] groupBy, String[] sumBy) {
        Field[] oldFields = ds.getRowMeta().getFields();
        String[] sel = new String[groupBy.length + sumBy.length];
        System.arraycopy(groupBy, 0, sel, 0, groupBy.length);
        System.arraycopy(sumBy, 0, sel, groupBy.length, sumBy.length);
        GroupbyDataSet groupbyDataSet = ds.select(sel).groupBy(groupBy);
        for (String sum : sumBy) {
            groupbyDataSet.sum(sum);
        }
        DataSet finish = groupbyDataSet.finish();
        finish = FeaUtil.gainSumSetHelper(finish, oldFields);
        return finish;
    }

    public static DataSet gainSumSetHelper(DataSet ds, Field[] oldFields) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> newCols = FeaUtil.getDataSetCols(ds);
        for (Field field : oldFields) {
            String name = field.getName().toLowerCase();
            if (newCols.contains(name)) {
                list.add(name);
                continue;
            }
            DataType dataType = field.getDataType();
            if (dataType instanceof LongType) {
                list.add("0L " + name);
                continue;
            }
            if (dataType instanceof IntegerType) {
                list.add("0 " + name);
                continue;
            }
            if (dataType instanceof BigDecimalType) {
                list.add("0.0 " + name);
                continue;
            }
            if (dataType instanceof StringType) {
                list.add("'' " + name);
                continue;
            }
            if (!(dataType instanceof BooleanType)) continue;
            list.add("false " + name);
        }
        ds = ds.select(list.toArray(new String[0]));
        return ds;
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName().toLowerCase());
        }
        return list;
    }

    public static String getDefaultOrgId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public static String join(Object[] arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Collection arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : arr) {
            sb.append(obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static Map<Long, Set<Long>> getBizOrgIds(Set<Long> acctOrgIds, long bookType) {
        QFilter orgFilter;
        HashMap<Long, Set<Long>> acctSysMap = new HashMap<Long, Set<Long>>();
        HashSet<Long> queryAcctOrgIds = new HashSet<Long>();
        Set bizOrgs = null;
        Map<String, Set<Long>> map = orgRelationMap.get();
        if (map == null) {
            map = new HashMap<String, Set<Long>>(16);
            orgRelationMap.set(map);
        }
        for (Long l : acctOrgIds) {
            bizOrgs = map.get(l + "_" + bookType);
            if (bizOrgs == null) {
                queryAcctOrgIds.add(l);
                continue;
            }
            acctSysMap.put(l, bizOrgs);
        }
        if (queryAcctOrgIds.size() == 0) {
            return acctSysMap;
        }
        HashMap queryAcctSysMap = new HashMap(queryAcctOrgIds.size());
        for (Long l : queryAcctOrgIds) {
            HashSet<Long> orgIds = new HashSet<Long>(1);
            orgIds.add(l);
            queryAcctSysMap.put(l, orgIds);
        }
        HashMap<Long, HashSet<Object>> hashMap = new HashMap<Long, HashSet<Object>>();
        QFilter qFilter = new QFilter("bookstype", "=", (Object)bookType);
        Map acctBookColl = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (String)"org,accountingsys", (QFilter[])new QFilter[]{qFilter, orgFilter = new QFilter("org", "in", queryAcctOrgIds)});
        if (null == acctBookColl || acctBookColl.size() == 0) {
            return null;
        }
        for (DynamicObject acctBook : acctBookColl.values()) {
            Long acctSys = (Long)acctBook.get("accountingsys_id");
            Long orgId = (Long)acctBook.get("org_id");
            HashSet<Object> orgList = (HashSet<Object>)hashMap.get(acctSys);
            if (orgList == null) {
                orgList = new HashSet<Object>();
                hashMap.put(acctSys, orgList);
            }
            orgList.add(orgId);
        }
        HashMap<Long, Long> orgToAcctOrgMap = new HashMap<Long, Long>();
        for (Map.Entry entry : hashMap.entrySet()) {
            Long acctSys = (Long)entry.getKey();
            DynamicObjectCollection acctsysColl = BaseDataServiceHelper.getAccountingSysBizOrg((Long)acctSys, (Long[])((Set)entry.getValue()).toArray(new Long[0]));
            if (null == acctsysColl || acctsysColl.size() <= 0) continue;
            for (DynamicObject acctBook : acctsysColl) {
                Long acctorgId = (Long)acctBook.get("bizacctorg");
                Long orgId = (Long)acctBook.get("bizorg");
                HashSet<Long> orgList = (HashSet<Long>)queryAcctSysMap.get(acctorgId);
                if (orgList == null) {
                    orgList = new HashSet<Long>();
                    orgList.add(acctorgId);
                    queryAcctSysMap.put(acctorgId, orgList);
                }
                orgList.add(orgId);
                orgToAcctOrgMap.put(orgId, acctorgId);
            }
        }
        QFilter j = new QFilter("toorg", "in", acctOrgIds);
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        Map bizOrgColl = BusinessDataServiceHelper.loadFromCache((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (null != bizOrgColl && bizOrgColl.size() > 0) {
            Long fromOrg = null;
            Long toOrg = null;
            for (DynamicObject relOrg : bizOrgColl.values()) {
                fromOrg = relOrg.getLong("fromorg.id");
                toOrg = relOrg.getLong("toorg.id");
                if (orgToAcctOrgMap.containsKey(fromOrg) || (bizOrgs = (Set)queryAcctSysMap.get(toOrg)) == null) continue;
                bizOrgs.add(fromOrg);
            }
        }
        for (Map.Entry entry : queryAcctSysMap.entrySet()) {
            map.put(entry.getKey() + "_" + bookType, (Set<Long>)entry.getValue());
        }
        acctSysMap.putAll(queryAcctSysMap);
        return acctSysMap;
    }
}

