/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fea.util.StructureUtil;

public class BizObjectEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeClickListener,
SearchEnterListener {
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";
    private TreeView treev;
    private static final String BASE_ROOT_ID = "1";
    private static final String AUXILIARY_ROOT_ID = "2";
    private static final String CACHE_QUICK_SEARCH = "cache_quick_search";
    private static String[] ENTRYFIELDS = new String[]{"number", "name", "cloud", "groupname", "type"};
    private static final String BOS_ENTITY = "bos_entityobject";
    private static final String BOS_ASSIST = "bos_assistantdatagroup";

    public void initialize() {
        super.initialize();
        TreeView fieldTree = (TreeView)this.getView().getControl("treeview");
        fieldTree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.treev = fieldTree;
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        EntryGrid entryentity = (EntryGrid)this.getControl(ENTRYENTITY);
        entryentity.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        TreeNode baseTree = this.initBaseTree();
        this.treev.addNode(baseTree);
        this.treev.focusNode(baseTree);
        this.treev.treeNodeClick("0", BASE_ROOT_ID);
    }

    private String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TreeNode initBaseTree() {
        TreeNode firstRoot = new TreeNode();
        firstRoot.setParentid("");
        firstRoot.setId(BASE_ROOT_ID);
        firstRoot.setText(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"BizObjectEditPlugin_1", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        firstRoot.setIsOpened(true);
        HashMap<String, List> basedataInfo = new HashMap<String, List>();
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name,bizcloud.id,bizcloud.name,masterid", null, (String)"bizcloud.number");
        String cCloudID = "";
        int childNum = 0;
        TreeNode cloudNode = null;
        HashMap<String, Set> idAndMatserId = new HashMap<String, Set>(entitys.length);
        for (DynamicObject entity : entitys) {
            String cloudId = entity.getString("bizcloud.id");
            if (cloudId == null) continue;
            if (!cCloudID.equalsIgnoreCase(cloudId)) {
                if (cloudNode != null && childNum > 0) {
                    firstRoot.addChild(cloudNode);
                    childNum = 0;
                }
                cCloudID = cloudId;
                cloudNode = new TreeNode();
                cloudNode.setParentid(BASE_ROOT_ID);
                cloudNode.setId(cCloudID);
                cloudNode.setType("cloud");
                cloudNode.setText(entity.getString("bizcloud.name"));
                cloudNode.setIsOpened(false);
            }
            if (StringUtils.isEmpty((String)entity.getString("masterid"))) {
                TreeNode appNode = new TreeNode();
                appNode.setParentid(cCloudID);
                appNode.setId(entity.getString("id"));
                appNode.setText(entity.getString("name"));
                appNode.setIsOpened(false);
                appNode.setType("app");
                if (cloudNode != null) {
                    cloudNode.addChild(appNode);
                }
                ++childNum;
                if (basedataInfo.get(cCloudID) == null) {
                    basedataInfo.computeIfAbsent(cCloudID, p -> new ArrayList()).add(entity.getString("id"));
                } else {
                    ((List)basedataInfo.get(cCloudID)).add(entity.getString("id"));
                }
                idAndMatserId.computeIfAbsent(entity.getString("id"), p -> new HashSet()).add(entity.getString("id"));
                continue;
            }
            idAndMatserId.computeIfAbsent(entity.getString("masterid"), p -> new HashSet()).add(entity.getString("id"));
        }
        if (cloudNode != null && childNum > 0) {
            firstRoot.addChild(cloudNode);
        }
        this.getPageCache().put("baseInfo", SerializationUtils.toJsonString(basedataInfo));
        this.getPageCache().put("idAndMatserId", SerializationUtils.toJsonString(idAndMatserId));
        return firstRoot;
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        String auxiliaryInfo = this.getPageCache().get("auxiliaryInfo");
        if (auxiliaryInfo == null) {
            this.initBastEntry(nodeId);
            return;
        }
        Map basedataInfo = (Map)this.fromSerializedString(auxiliaryInfo);
        TreeNode treenode = (TreeNode)basedataInfo.get(nodeId);
        if (!nodeId.equals(AUXILIARY_ROOT_ID) && treenode == null) {
            this.initBastEntry(nodeId);
        }
    }

    private List<TreeNode> getChildrenNodes(TreeNode node) {
        List childrenNodes = node.getChildren();
        ArrayList<TreeNode> returnChildrenNodes = new ArrayList<TreeNode>();
        if (childrenNodes == null) {
            return null;
        }
        returnChildrenNodes.addAll(childrenNodes);
        for (TreeNode childNode : childrenNodes) {
            List<TreeNode> childrenNode = this.getChildrenNodes(childNode);
            if (childrenNode == null) continue;
            returnChildrenNodes.addAll(childrenNode);
        }
        return returnChildrenNodes;
    }

    private void initBastEntry(String nodeId) {
        IPageCache pageCache = this.getPageCache();
        String baseInfo = pageCache.get("baseInfo");
        String idAndMatserIdstr = pageCache.get("idAndMatserId");
        Map basedataInfo = (Map)SerializationUtils.fromJsonString((String)baseInfo, Map.class);
        Map idAndMatserId = (Map)SerializationUtils.fromJsonString((String)idAndMatserIdstr, Map.class);
        ArrayList<String> nodeIds = new ArrayList<String>();
        if (nodeId.equals(BASE_ROOT_ID)) {
            basedataInfo.forEach((k, v) -> nodeIds.addAll((Collection<String>)v));
        } else if (basedataInfo.get(nodeId) != null) {
            nodeIds.addAll((Collection)basedataInfo.get(nodeId));
        } else {
            nodeIds.add(nodeId);
        }
        HashSet appIds = new HashSet();
        for (String node : nodeIds) {
            if (!idAndMatserId.containsKey(node)) continue;
            appIds.addAll((Collection)idAndMatserId.get(node));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        filterList.add(new QFilter("bizappid", "in", appIds));
        filterList.add(new QFilter("bizappid.number", "!=", (Object)"ds"));
        filterList.add(new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel"}));
        filterList.add(new QFilter("id", "!=", (Object)"ai_accountmaptype"));
        filterList.add(new QFilter("id", "!=", (Object)"bos_adminorg_structure"));
        String quickSearchStr = this.getPageCache().get(CACHE_QUICK_SEARCH);
        if (quickSearchStr != null) {
            List quickSearch = (List)this.fromSerializedString(quickSearchStr);
            filterList.addAll(quickSearch);
        }
        IDataModel model = this.getModel();
        model.deleteEntryData(ENTRYENTITY);
        List<List<Object>> baseDatas = this.getEntryDatas(BOS_ENTITY, "name,number,bizappid.name groupname,bizappid.bizcloud.name cloud,modeltype type", filterList.toArray(new QFilter[0]));
        if (!baseDatas.isEmpty()) {
            StructureUtil.addLevel(ENTRYFIELDS, baseDatas, this.getView(), ENTRYENTITY);
        }
    }

    private List<List<Object>> getEntryDatas(String entitykey, String selectedFields, QFilter[] qs) {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(2000);
        try (DataSet dt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entitykey, (String)selectedFields, (QFilter[])qs, (String)"number");){
            Row row = null;
            ArrayList<Object> rowdata = null;
            while (dt.hasNext()) {
                row = dt.next();
                rowdata = new ArrayList<Object>(4);
                for (String field : ENTRYFIELDS) {
                    if (field.equals("type")) {
                        switch (row.getString(field)) {
                            case "BillFormModel": {
                                rowdata.add(ResManager.loadKDString((String)"\u5355\u636e", (String)"BizObjectEditPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                                break;
                            }
                            case "BaseFormModel": {
                                rowdata.add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"BizObjectEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                                break;
                            }
                            case "1": {
                                rowdata.add(ResManager.loadKDString((String)"\u8f85\u52a9\u8d44\u6599", (String)"BizObjectEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
                                break;
                            }
                        }
                        continue;
                    }
                    rowdata.add(row.get(field));
                }
                datas.add(rowdata);
            }
        }
        return datas;
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity(ENTRYENTITY);
        int index = model.getEntryCurrentRowIndex(ENTRYENTITY);
        DynamicObject currow = (DynamicObject)entry.get(index);
        if (index != -1 && currow != null) {
            this.getView().returnDataToParent((Object)currow);
            this.getView().close();
        }
    }

    public void search(SearchEnterEvent evt) {
        List searchFields = evt.getSearchFields();
        if (searchFields == null) {
            this.getPageCache().remove(CACHE_QUICK_SEARCH);
            TreeView tree = (TreeView)this.getView().getControl("treeview");
            tree.treeNodeClick("", BASE_ROOT_ID);
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        for (Map search : searchFields) {
            List fieldNames = (List)search.get("fieldName");
            List values = (List)search.get("value");
            QFilter filter = null;
            for (String fieldName : fieldNames) {
                for (String value : values) {
                    if (filter == null) {
                        filter = new QFilter(fieldName, "ftlike", (Object)("%" + value + "%"));
                        continue;
                    }
                    filter.or(fieldName, "ftlike", (Object)("%" + value + "%"));
                }
            }
            filters.add(filter);
        }
        String filterStr = this.toSerializedString(filters);
        this.getPageCache().put(CACHE_QUICK_SEARCH, filterStr);
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        tree.treeNodeClick("", BASE_ROOT_ID);
    }
}

