/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.fi.fea.util.FeaUtil;
import kd.fi.fea.util.ThrowableHelper;

public class CommonFilterFormPlugin
extends AbstractFormPlugin {
    private static final String BIZDATE = "bizdate";
    private static final String PERIOD = "period";
    private static final String BIZORG = "bizorg";
    private static final String OTHERFILTER = "otherfilter";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    private void returnData() {
        IDataModel model = this.getModel();
        String bizdate = (String)model.getValue(BIZDATE);
        String period = (String)model.getValue(PERIOD);
        String bizorg = (String)model.getValue(BIZORG);
        String otherfilter = (String)model.getValue(OTHERFILTER);
        if (StringUtils.isNotEmpty((CharSequence)otherfilter)) {
            try {
                QFilter.of((String)otherfilter, (Object[])new Object[0]);
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5176\u5b83\u8fc7\u6ee4\u8868\u8fbe\u5f0f\u65e0\u6cd5\u89e3\u6790%s", (String)"CommonFilterFormPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]), ThrowableHelper.toString((Exception)e)));
            }
        }
        String entity = (String)model.getValue("entity");
        String entitydesc = (String)model.getValue("entitydesc");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("entity", entity);
        map.put("entitydesc", entitydesc);
        map.put(BIZDATE, bizdate);
        map.put(PERIOD, period);
        map.put(BIZORG, bizorg);
        map.put(OTHERFILTER, otherfilter);
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter par = view.getFormShowParameter();
        String entity = (String)par.getCustomParam("entity");
        String entitydesc = (String)par.getCustomParam("entitydesc");
        String commonfilter = (String)par.getCustomParam("commonfilter");
        IDataModel model = this.getModel();
        model.setValue("entity", (Object)entity);
        model.setValue("entitydesc", (Object)entitydesc);
        if (!StringUtils.isEmpty((CharSequence)commonfilter)) {
            JSONObject filterMap = JSONObject.parseObject((String)commonfilter);
            String period = String.valueOf(filterMap.get(PERIOD));
            String bizdate = String.valueOf(filterMap.get(BIZDATE));
            String bizorg = String.valueOf(filterMap.get(BIZORG));
            String otherFilter = String.valueOf(filterMap.get(OTHERFILTER));
            model.setValue(PERIOD, (Object)period);
            model.setValue(BIZDATE, (Object)bizdate);
            model.setValue(BIZORG, (Object)bizorg);
            model.setValue(OTHERFILTER, (Object)otherFilter);
        }
    }

    public void afterBindData(EventObject e) {
        String entity = (String)this.getModel().getValue("entity");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        this.initBaseDataItems("bos_org", BIZORG, mainEntityType);
        this.initBaseDataItems("bd_period", PERIOD, mainEntityType);
        this.fillDateItems(mainEntityType);
    }

    private void initBaseDataItems(String prop, String field, MainEntityType mainEntityType) {
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.add(prop);
        List items = FeaUtil.buildPropComboItems(entityIds, (MainEntityType)mainEntityType, (boolean)true, (boolean)true, (boolean)true);
        ComboEdit orgEditor = (ComboEdit)this.getView().getControl(field);
        orgEditor.setComboItems(items);
    }

    private void fillDateItems(MainEntityType srcMainET) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        String currLCId = Lang.get().toString();
        if (srcMainET != null) {
            for (IDataEntityProperty prop : srcMainET.getProperties()) {
                if (!(prop instanceof DateTimeProp) || !StringUtils.isNotEmpty((CharSequence)prop.getAlias())) continue;
                DateTimeProp dateProp = (DateTimeProp)prop;
                ComboItem item = new ComboItem();
                item.setValue(dateProp.getName());
                item.setCaption(new LocaleString(currLCId, this.buildPropCaption((DynamicProperty)dateProp)));
                items.add(item);
            }
        }
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(BIZDATE);
        fieldEditor.setComboItems(items);
    }

    private String buildPropCaption(DynamicProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"CommonFilterFormPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : this.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    private String getFieldSelector(DynamicProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }
}

