/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fea.util.StructureUtil;

public class DataStructureEditPlugin
extends AbstractBillPlugIn {
    private static final String DELETEENTRY = "deleteentry";
    private static final String BOS_TEMPLATE_TREE_LIST = "bos_templatetreelist";
    private static final String TOOLBARAP = "advcontoolbarap";
    private static String[] ELEMENTFIELDS = new String[]{"refid", "refentryid", "pid", "type", "multype", "value", "valuedesc", "id"};

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{"entitydesc", "commonfilterdesc", "valuedesc"});
    }

    public void click(EventObject evt) {
        String key;
        Control ctlSource = (Control)evt.getSource();
        switch (key = ctlSource.getKey()) {
            case "entitydesc": {
                this.showBizObjectView(key);
                break;
            }
            case "commonfilterdesc": {
                this.showCommonFilterView(key);
                break;
            }
            case "valuedesc": {
                this.showExpView(key);
                break;
            }
        }
    }

    private void showExpView(String key) {
        IDataModel model = this.getModel();
        String entity = (String)model.getValue("entity");
        String entitydesc = (String)model.getValue("entitydesc");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"DataStructureEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        String valuedesc = (String)model.getValue("valuedesc", rowIndex);
        FormShowParameter par = new FormShowParameter();
        par.getOpenStyle().setShowType(ShowType.Modal);
        par.setFormId("fea_formula");
        par.setCustomParam("entity", (Object)entity);
        par.setCustomParam("entitydesc", (Object)entitydesc);
        par.setCustomParam("datatype", model.getValue("datatype", rowIndex));
        if (!StringUtils.isEmpty((CharSequence)valuedesc)) {
            par.setCustomParam("valuedesc", (Object)valuedesc);
            String value = (String)model.getValue("value", rowIndex);
            par.setCustomParam("value", (Object)value);
        }
        par.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(par);
    }

    private void showBizObjectView(String key) {
        FormShowParameter par = new FormShowParameter();
        par.getOpenStyle().setShowType(ShowType.Modal);
        par.setFormId("fea_bizobject");
        par.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(par);
    }

    private void showCommonFilterView(String key) {
        IDataModel model = this.getModel();
        String entity = (String)model.getValue("entity");
        String entitydesc = (String)model.getValue("entitydesc");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"DataStructureEditPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
            return;
        }
        String commonfilter = (String)model.getValue("commonfilter");
        FormShowParameter par = new FormShowParameter();
        par.getOpenStyle().setShowType(ShowType.Modal);
        par.setFormId("fea_commonfilter");
        par.setCustomParam("entity", (Object)entity);
        par.setCustomParam("entitydesc", (Object)entitydesc);
        if (!StringUtils.isEmpty((CharSequence)commonfilter)) {
            par.setCustomParam("commonfilter", (Object)commonfilter);
        }
        par.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        this.getView().showForm(par);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "baritemaddlevel": 
            case "baritemaddsub": {
                StructureUtil.showF7ListView(key, this.getView(), (IFormPlugin)this);
                break;
            }
            case "deleteentry": {
                this.deleteEntry();
                break;
            }
            case "fixall": {
                DynamicObject[] dyos;
                List ids = QueryServiceHelper.queryPrimaryKeys((String)"fea_datastructure", null, null, (int)-1);
                for (DynamicObject dyo : dyos = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fea_datastructure"))) {
                    String commonfilter = dyo.getString("commonfilter");
                    try {
                        if (!StringUtils.isEmpty((CharSequence)commonfilter)) {
                            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)commonfilter);
                            dyo.set("commonfilter", JSON.toJSON((Object)map));
                        }
                        DynamicObjectCollection entry = dyo.getDynamicObjectCollection("treeentryentity");
                        for (DynamicObject row : entry) {
                            String value = row.getString("value");
                            if (StringUtils.isEmpty((CharSequence)value)) continue;
                            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)value);
                            row.set("value", JSON.toJSON((Object)map));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SaveServiceHelper.save((DynamicObject[])dyos);
                break;
            }
        }
    }

    private boolean isBizObjectUsed() {
        IDataModel model = this.getModel();
        String commonfilter = (String)model.getValue("commonfilter");
        if (!StringUtils.isEmpty((CharSequence)commonfilter)) {
            return true;
        }
        DynamicObjectCollection entry = model.getEntryEntity("treeentryentity");
        for (DynamicObject row : entry) {
            String value = row.getString("value");
            if (StringUtils.isEmpty((CharSequence)value)) continue;
            return true;
        }
        return false;
    }

    private void deleteEntry() {
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int[] rowIndexs = proxy.getEntryState("treeentryentity").getSelectedRows();
        if (rowIndexs.length > 0 && rowIndexs[0] != -1) {
            DynamicObjectCollection entry = model.getEntryEntity("treeentryentity");
            model.deleteEntryRows("treeentryentity", rowIndexs);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u4e00\u884c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DataStructureEditPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent close) {
        super.closedCallBack(close);
        String key = close.getActionId();
        Object returnData = close.getReturnData();
        switch (key) {
            case "baritemaddsub": 
            case "baritemaddlevel": {
                if (!(returnData instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection selects = (ListSelectedRowCollection)returnData;
                List<List<Object>> rows = StructureUtil.getLevelRows(selects.getPrimaryKeyValues(), key, true, null);
                StructureUtil.addLevel(ELEMENTFIELDS, rows, this.getView(), "treeentryentity");
                StructureUtil.fillEntry(this.getModel());
                break;
            }
            case "entitydesc": {
                if (!(returnData instanceof DynamicObject)) break;
                DynamicObject dyo = (DynamicObject)returnData;
                IDataModel model = this.getModel();
                model.setValue("entitydesc", (Object)dyo.getString("name"));
                model.setValue("entity", (Object)dyo.getString("number"));
                break;
            }
            case "commonfilterdesc": {
                if (!(returnData instanceof Map)) break;
                Map map = (Map)returnData;
                String commonfilterdesc = (String)map.get("entitydesc");
                this.getModel().setValue("commonfilterdesc", (Object)commonfilterdesc);
                this.getModel().setValue("commonfilter", JSON.toJSON((Object)map));
                break;
            }
            case "valuedesc": {
                if (returnData == null) break;
                Map map = (Map)returnData;
                int i = this.getModel().getEntryCurrentRowIndex("treeentryentity");
                Map valueMap = (Map)map.get("value");
                this.getModel().setValue("value", JSON.toJSON((Object)valueMap), i);
                this.getModel().setValue("valuedesc", map.get("valuedesc"), i);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (keyName) {
            case "commonfilterdesc": {
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) break;
                this.getModel().setValue("commonfilter", null);
                break;
            }
            case "group": {
                this.getModel().deleteEntryData("treeentryentity");
                break;
            }
            case "commonfilter": {
                if (StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"entitydesc"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(!this.isBizObjectUsed()), new String[]{"entitydesc"});
                break;
            }
            case "value": {
                if (StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"entitydesc"});
                    break;
                }
                this.getView().setEnable(Boolean.valueOf(!this.isBizObjectUsed()), new String[]{"entitydesc"});
                break;
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        IFormView parentView = this.getView().getParentView();
        if (parentView instanceof ListView) {
            String billFormId = parentView.getFormShowParameter().getFormId();
            if (BOS_TEMPLATE_TREE_LIST.equals(billFormId)) {
                this.getModel().setValue("iscommon", (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue("iscommon", (Object)Boolean.FALSE);
            }
        } else {
            this.getModel().setValue("iscommon", (Object)Boolean.FALSE);
        }
    }

    public void afterLoadData(EventObject e) {
        StructureUtil.fillEntry(this.getModel());
        String commonfilter = (String)this.getModel().getValue("commonfilter");
        JSONObject filterMap = JSONObject.parseObject((String)commonfilter);
        if (filterMap != null) {
            this.getModel().setValue("commonfilterdesc", filterMap.get("entitydesc"));
        }
    }

    public void afterBindData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        Boolean iscopy = (Boolean)param.getCustomParam("iscopy");
        if (iscopy != null && iscopy.booleanValue()) {
            StructureUtil.fillEntry(this.getModel());
        }
        this.getView().setEnable(Boolean.valueOf(!this.isBizObjectUsed()), new String[]{"entitydesc"});
        this.getModel().setDataChanged(false);
    }
}

