/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fea.datastructure.DataStructureListProvider;

public class DataStructureListPlugin
extends AbstractTreeListPlugin {
    private static final String BTN_RETURN_DATA = "btnreturndata";
    private static final String CLICK_NEW = "clicknew";
    private static final String CLICK_DELETE = "clickdelete";
    private static final String CALL_BACK_ADD_NEW = "call_back_add_new";
    private static final String BILL_LIST_AP = "billlistap";
    private static final String FEA_STRUCTURE_F7 = "fea_structure_f7";
    private static final String BOS_TEMPLATE_TREE_LIST = "bos_templatetreelist";
    private static final String BTN_IS_CONTAIN_LOWER = "iscontainlower";

    public void initialize() {
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_IS_CONTAIN_LOWER, "btndel", "btnedit", "btnnew"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        args.setListDataProvider((IListDataProvider)new DataStructureListProvider());
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{CLICK_NEW, CLICK_DELETE, BTN_RETURN_DATA});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (CLICK_NEW.equals(key)) {
            this.showFormView(0L);
        } else if (CLICK_DELETE.equals(key)) {
            this.deleteElement();
        } else if (BTN_RETURN_DATA.equals(key)) {
            this.returnData();
        }
    }

    public void setFilter(SetFilterEvent e) {
        String formId = this.getView().getFormShowParameter().getFormId();
        if (BOS_TEMPLATE_TREE_LIST.equals(formId)) {
            QFilter filter = new QFilter("iscommon", "=", (Object)Boolean.TRUE);
            e.addCustomQFilter(filter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        this.refreshData();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        HyperLinkClickEvent hyperLinkClickEvent = args.getHyperLinkClickEvent();
        BillList list = (BillList)hyperLinkClickEvent.getSource();
        IListView view = (IListView)list.getView();
        String formId = view.getFormShowParameter().getFormId();
        if (FEA_STRUCTURE_F7.equals(formId)) {
            args.setCancel(true);
            long id = (Long)((IListView)this.getView()).getFocusRowPkId();
            this.showFormView(id);
        }
    }

    private void returnData() {
        IListView listView = (IListView)this.getView();
        ListSelectedRowCollection collection = new ListSelectedRowCollection();
        if (!listView.getCurrentListAllRowCollection().isEmpty()) {
            collection = listView.getSelectedRows();
        }
        this.getView().returnDataToParent((Object)collection);
        this.getView().close();
    }

    private void showFormView(long id) {
        BillShowParameter param = new BillShowParameter();
        param.setFormId("fea_datastructure");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALL_BACK_ADD_NEW));
        if (id != 0L) {
            param.setPkId((Object)id);
            param.setStatus(OperationStatus.EDIT);
        } else {
            param.setStatus(OperationStatus.ADDNEW);
        }
        this.getView().showForm((FormShowParameter)param);
    }

    private void deleteElement() {
        IListView view = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = view.getSelectedRows();
        if (selectedRows.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e", (String)"DataStructureListPlugin_0", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Object> deletePk = new ArrayList<Object>();
        for (ListSelectedRow row : selectedRows) {
            Object pkValue = row.getPrimaryKeyValue();
            deletePk.add(pkValue);
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fea_element", (Object[])deletePk.toArray(), null);
        if (!result.isSuccess()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5143\u7d20\u5df2\u88ab\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"DataStructureListPlugin_2", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"DataStructureListPlugin_1", (String)"fi-fea-formplugin", (Object[])new Object[0]));
        view.refresh();
        ((BillList)this.getControl(BILL_LIST_AP)).clearSelection();
    }

    private void refreshData() {
        IListView listView = (IListView)this.getView();
        BillList list = (BillList)this.getControl(BILL_LIST_AP);
        listView.refresh();
        list.clearSelection();
    }
}

