/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fea.datastructure;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListField;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DataStructureListProvider
extends ListDataProvider {
    public void setListFields(List<ListField> listFields) {
        super.setListFields(listFields);
        HashSet<String> fields = new HashSet<String>(listFields.size());
        for (ListField listField : listFields) {
            fields.add(listField.getFieldName());
        }
        if (!fields.contains("entity")) {
            ListField listField = new ListField("entity");
            listField.setFieldName("entity");
            listFields.add(listField);
        }
    }

    public DynamicObjectCollection getData(int start, int limit) {
        DynamicObjectCollection datas = super.getData(start, limit);
        HashSet<String> entityKeys = new HashSet<String>();
        boolean containsDisplayProp = false;
        for (DynamicObject data : datas) {
            if (data.containsProperty("entitydesc")) {
                containsDisplayProp = true;
            }
            String entity = data.getString("entity");
            entityKeys.add(entity);
        }
        if (containsDisplayProp) {
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("number", "in", entityKeys)});
            Map<String, String> entityNameMap = Arrays.stream(load).collect(Collectors.toMap(d -> d.getString("number"), d -> d.getString("name")));
            for (DynamicObject data : datas) {
                String entity = data.getString("entity");
                if (!data.containsProperty("entitydesc")) continue;
                String name = entityNameMap.get(entity);
                data.set("entitydesc", (Object)name);
            }
        }
        return datas;
    }
}

